<?php

namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class UserNotification extends Model
{
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'title',
        'description',
        'is_read',
        'order_id',
        'order_status_id',
        'status_id',
    ];

     /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'updated_at','deleted_at'
    ];

    public function getCreatedAtAttribute($value)
    {
         return date("d/m/Y");
    }


      /**
     * 
     * 
     */
    
    public function getUserNotificationHistoryTotalPage($user_id,$limit)
    {
         $result    =  self::select('title','description','order_id')
                        ->where('user_id',$user_id)
                        ->paginate(($limit) ? $limit :5);
        $total_page = (int)ceil($result->total()/$result->perPage());
        return $total_page;
    }

    /**
     * 
     * 
     * 
     */
    public function getUserNotificationHistory($user_id,$limit,$offset)
    {
        return   self::select('title','description','is_read','order_id','created_at')
                    ->where('user_id',$user_id)
                    ->orderBy('created_at','DESC')
                    ->offset(($offset) ? $offset :0)
                    ->limit(($limit) ? $limit :5)
                    ->get();
    }

    /**
    *
    *
    */
    public function getUserNotificationById($id)
    {
         return self::where('id',$id)->first();
    }

    /**
    *
    *
    */
    public function createNotification($input)
    {
        return self::create($input);
    }

    /**
    *
    *
    */
    public function updateNotification($id, $input)
    {
        return self::where('id',$id)->update($input);
    }

    public function markAllAsRead($user_id , $input)
    {
        return self::where('user_id',$user_id)->update($input);
    }

     /**
    *
    *
    */
    public function deleteNotification($id)
    {
        return self::where('id',$id)->delete();
    }

    public function getUserNotifications($user_id)
    {
        return self::select('id','description','is_read','created_at')->where('user_id',$user_id)->orderBy('id','DESC')->latest()->get();
    }

    public function getUserUnreadNotificationCount($user_id)
    {
        return self::where('user_id',$user_id)->where('is_read',0)->count();
    }

    public function updateAllNotification($user_id)
    {
        return self::where('user_id',$user_id)
                    ->update(['is_read'=>1]);
    }
}
