<?php
namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;
class Vendor extends Model
{
    use SoftDeletes;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'address',
        'profile_image',
        'user_id',
        'is_active',
        'phone',
        'pincode',
        'whatsapp_no',
        'email',
        'gst',
        'account_name',
        'account_number',
        'ifsc',
        'upi_id',
        'bank_name',
        'branch_name',
        'is_approve'

    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at','updated_at','deleted_at'
    ];

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function firebaseToken()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function resellerRequestExist($phone,$email){
        return self::where('phone',$phone)
        ->orWhere('email',$email)
        ->first();
    }

    /**
    * 
    * @return void
    */
    public function createVendor($request, $user_id)
    {

        $data    = [
            'phone'              => $request->phone,
            'whatsapp_no'        => $request->whatsapp_no,
            'name'               => $request->name,
            'email'              => $request->email,
            'address'            => $request->address,
            'pincode'            => $request->pincode,
            'user_id'            => $user_id,
            'is_active'          => $request->is_active,
            'gst'                => $request->gst,
            'account_name'       => $request->account_name,
            'account_number'     => $request->account_number,
            'bank_name'          => $request->bank_name,
            'branch_name'        => $request->branch_name,
            'ifsc'               => $request->ifsc,
            'upi_id'             => $request->upi_id,
            'is_approve'         => Carbon::now()->format('Y-m-d H:i:s')
        ];
      
        return self::create($data);
    }

    public function requestSeller($reseller)
    {
        $data    = [
            'phone'              => $reseller->vendor_phone,
            'whatsapp_no'        => $reseller->whatsapp_no,
            'name'               => $reseller->vendor_name,
            'email'              => $reseller->vendor_email,
            'profile_image'      => $reseller->profile_image,
            'address'            => $reseller->vendor_address,
            'user_id'            => $reseller->user_id,
            'pincode'            => $reseller->pincode,
            'is_active'          => 0,
            'gst'                => $reseller->gst,
            'account_name'       => $reseller->account_name,
            'account_number'     => $reseller->account_number,
            'bank_name'          => $reseller->bank_name,
            'branch_name'        => $reseller->branch_name,
            'ifsc'               => $reseller->ifsc,
            'upi_id'             => $reseller->upi_id
        ];
        
        return self::create($data);
    }

    /**
     * 
     * 
     * 
     */
    public function getVendorList($request)
    {
        $query =  self::where('is_approve','!=',null)->where('deleted_at',null);
        if( isset($request->search) && !empty($request->search))
        {
            $query = $query->where("name",'LIKE','%'.$request->search.'%');
        }
        return $query->paginate($request->limit);
    }


    /**
     * 
     * 
     * 
     */
    public function getUnapprovedVendorList($request)
    {
        $query =  self::where('is_approve',null)->where('deleted_at',null);
        if( isset($request->search) && !empty($request->search))
        {
            $query = $query->where("name",'LIKE','%'.$request->search.'%');
        }
        return $query->paginate($request->limit);
    }

    /**
     * 
     * 
     * 
     */
    public function delVendor($id)
    {
        return self::where('id',$id)->delete();
        
    }
    /**
     * 
     * 
     */
    public function getSingleVendor($id)
    {
        return self::find($id);
    }

    public function updateVendor($request,$id)
    {
       
        $data    = [
            'phone'              => $request->phone,
            'whatsapp_no'        => $request->whatsapp_no,
            'name'               => $request->name,
            'email'              => $request->email,
            'address'            => $request->address,
            'pincode'            => $request->pincode,
            'is_active'          => $request->is_active,
            'gst'                => $request->gst,
            'account_name'       => $request->account_name,
            'account_number'     => $request->account_number,
            'bank_name'          => $request->bank_name,
            'branch_name'        => $request->branch_name,
            'ifsc'               => $request->ifsc,
            'upi_id'             => $request->upi_id,
        ];
        return self::where('id',$id)->update($data);
    }
    
    public function getVendors()
    {
        return self::get();
    }

    public function changeStatus($id)
    {
        $vendor =  self::where('id',$id)->first();
        if($vendor->is_active == 1)
        {
            return self::where('id',$id)->update(['is_active' => 0]);
        }
        else
        {
            return self::where('id',$id)->update(['is_active' => 1]);
        }
    }

    public function changeApproveStatus($id)
    {
        $reseller =  self::where('id',$id)->first();
        if($reseller->is_approve == null)
        {
            return self::where('id',$id)->update(['is_approve' => Carbon::now()->format('Y-m-d H:i:s')]);
            User::where('id',$reseller->user_id)->update(['is_vendor' => Carbon::now()->format('Y-m-d H:i:s')]);
        }
    }

    public function getApproveStatus($id)
    {
        return self::where('id',$id)
                    ->whereNotNull('is_approve')
                    ->first();
    }

    public function getVendorByUserId($user_id)
    {
        return self::where('user_id',$user_id)->first();
    }

    public function getVendorById($id)
    {
        return self::where('id',$id)->first();
    }

    /**
     * 
     * @author PMS
     * 
     */
    public function getSearchVendor($search_key)
    {
        return   self::select('id','name','address','profile_image')
        ->where('name','LIKE','%'.$search_key.'%')
        ->where('is_approve','!=',null)
        ->limit(20)
        ->get();
    }

    /**
     * 
     * 
     */
    public function updateVendorProfile($request)
    {
        return self::where('user_id',$request->user_id)->update([
            "name"          => $request->name,
            "address"       => $request->address,
            "phone"         => $request->phone,
            "email"         => $request->email,
            "profile_image" => $request->logo
        ]);
    }

    /**
     * 
     * 
     */
    public function getVendorsTotalPage($limit)
    {
        $result    =  self::paginate(($limit) ? $limit :12);
        $total_page = (int)ceil($result->total()/$result->perPage());
        return $total_page;
    }

    /**
     * 
     * 
     */
    public function getVendorsListByOffset($limit,$offset)
    {
        return self::select('id','user_id','name','address','phone','profile_image')
        ->whereNotNull('is_approve')
        ->where('is_active',1)
        ->offset(($offset) ? $offset :0)
        ->limit(($limit) ? $limit :12)
        ->get();
    }
}
