<?php

namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class VendorNotification extends Model
{
    use SoftDeletes;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'title',
        'description',
        'is_read',
        'order_id',
        'order_status_id',
        'status_id',
    ];

    /**
     * 
     * @author PMS
     * 
     */
    protected $casts = [
        'is_read' => 'boolean',
      ];
     /**
     * 
     */
    public function getCreatedAtAttribute($value)
    {
         return Carbon::parse($value)->format('d-m-Y h:i:s a');
    }
    /**
    *
    *@author PMS
    */
    public function createNotification($input)
    {
        return self::create($input);
    }

    /**
     * 
     * 
     */
    
    public function getNotificationHistoryTotalPage($user_id,$limit)
    {
         $result    =  self::select('title','description','order_id')
                        ->where('user_id',$user_id)
                        ->orderBy('id','desc')
                        ->paginate(($limit) ? $limit :5);
        $total_page = (int)ceil($result->total()/$result->perPage());
        return $total_page;
    }

    /**
     * 
     * 
     * 
     */
    public function getNotificationHistory($user_id,$limit,$offset)
    {
        return   self::select('id','title','description','is_read','created_at')
                    ->where('user_id',$user_id)
                    ->orderBy('id','desc')
                    ->offset(($offset) ? $offset :0)
                    ->limit(($limit) ? $limit :5)
                    ->get();
    }

    /**
     * 
     * 
     */
    public function updateAllNotification($user_id)
    {
        return self::where('user_id',$user_id)
                ->update(['is_read'=>1]);
    }
}
