<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Wishlist extends Model
{
    //
    use SoftDeletes;

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';

    /**
     * fillable colums
     *
     * @var array
     */
    protected $fillable = [
        'reseller_id',
        'item_id'
    ];
    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'deleted_at','created_at','updated_at'
    ];
   
    /**
    * 
    * @return void
    */
    public function reseller()
    {
        return $this->belongsTo('App\Models\Reseller','reseller_id','id');
    }

        /**
    * 
    * @return void
    */
    public function product()
    {
        return $this->belongsTo('App\Models\Item','item_id','id')->with('gallery');
    }


   
    /**
     * add products to user wishlist
     * @author  Rahul
     * 
     */
    public function createWishlist($input)
    {
        return self::create($input);
    }

     /**
     * 
     * @author  RAHUL
     * 
     */
    public function updateWishlist($id , $input)
    {
        return self::where('id',$id)->update($input);
    }
    /**
     * 
     * 
     */
    public function getWishlistByUserId($reseller_id)
    {
         return self::with('product')
            ->where('reseller_id', $reseller_id)
            ->first();
    }
    /**
     * 
     * 
     */
    public function getUserProductInWishlist($reseller_id , $item_id)
    {
        return self::where('item_id', $item_id)->orWhere('reseller_id',$reseller_id)->first();
    }
    /**
     * 
     * 
     */
     /**
     * 
     * 
     */
    public function removeFromWishlist($request)
    {
        return self::where('item_id', $request->product_id)->where('reseller_id',$request->reseller_id)->delete();
    }
    /**
     * 
     * 
     */
    public function getWishlist($reseller_id)
    {
         return self::with('product')
            ->where('reseller_id', $reseller_id)
            ->get();
    }

    public function getItem($item_id,$reseller_id)
    {
         return self::where('reseller_id', $reseller_id)
            ->where('item_id', $item_id)
            ->first();
    }
}
