<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class itemImage extends Model
{
    use SoftDeletes;

    /**
   * The attributes that are mass assignable.
   *
   * @var array
   */
  protected $fillable = [

      'name',
      'image',
      'item_id'
  ];



  /**
   * The attributes excluded from the model's JSON form.
   *
   * @var array
   */
  protected $hidden = [
      'updated_at','deleted_at'
  ];

  public function getGalleryImageById($id)
  {
     return self::where('id', $id)->first();
  }

  public function createGallery($input)
  {
      return self::create($input);
  }

  public function getGalleryList($request)
  {

      $query =  self::where('deleted_at',NULL)->where('item_id',$request->item_id);
      if( isset($request->search) && !empty($request->search))
      {
          $query = $query->where("name",'LIKE','%'.$request->search.'%');
      }
      return $query->paginate($request->limit);
  }

  public function updateGalleryImage($id,$data)
  {
     return self::where('id', $id)
                  ->update($data);
  }

  public function galleryDelete($id)
  {
      return self::where('id',$id)->delete();
  }

  public function deleteItemImage($item_id)
  {
    return self::where('item_id',$item_id)->delete();
  }

  public function deleteItemImageFromGallery($image_url)
  {
    return self::where('image',$image_url)->forceDelete();
  }

}
