<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Auth;
use Google\Service\Docs\Request;

class productType extends Model
{
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'slug'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at',
        'updated_at',
        'deleted_at',
        'pivot'
    ];

    public function setSlugAttribute($value)
    {
        $slug = $value ? Str::slug($value) : Str::slug($this->attributes['title'] ?? '');
        $this->attributes['slug'] = $this->generateUniqueSlug($slug);
    }

    protected function generateUniqueSlug($baseSlug)
    {
        $slug = $baseSlug;
        $count = 1;
        while (
            static::where('slug', $slug)
            ->where('id', '!=', $this->id)
            ->exists()
        ) {
            $slug = "{$baseSlug}-{$count}";
            $count++;
        }
        return $slug;
    }


    /**
     * 
     * 
     * 
     */
    public function products()
    {
        return $this->hasMany('App\Models\Item');
    }
    /**
     *Pivot Table
     *@author SOORYA
     */
    public function items()
    {
        return $this->belongsToMany(\App\Models\Item::class)->withTimestamps();
    }

    /**
     * 
     * @return void
     */
    public function getImageAttribute($value)
    {
        return url("/") . $value;
    }

    /**
     *
     *@author RAHUL
     */
    // public function getAllCategories()
    // {
    //     return self::select('id','name')->get();
    // }

    /**
     *
     *@author RAHUL
     */
    public function getAdminProductTypes()
    {
        return self::get();
    }


    /**
     *
     *
     *@author RAHUL
     */
    public function getSingleProduct($id)
    {
        return self::where('id', $id)->first();
    }


    /**
     *
     *
     *@author RAHUL
     */
    public function deleteCategory($id)
    {
        return self::where('id', $id)->delete();
    }


    /**   
     *
     *@author RAHUL
     */
    public function updateProduct($id, $input)
    {
        return self::where('id', $id)->update($input);
    }

    /**   
     *
     *@author RAHUL
     */
    public function createProduct($input)
    {
        return self::create($input);
    }


    public function getProductTypes()
    {
        return self::get();
    }

    /**
     *Pivot Table
     *@author SOORYA
     */
    public function getExcludedProductTypes($selected_product_types)
    {
        $data = [];
        for ($i = 0; $i < count($selected_product_types); $i++) {
            $data[] = $selected_product_types[$i]->product_type_id;
        }

        return self::whereNotIn('id', $data)->get();
    }

    /**
     *
     *@author RAHUL
     */
    public function getAdminProductList($request)
    {
        return self::select('id', 'name', 'slug')->paginate($request->limit);
    }



    public function getCategoryWithProducts($categories)
    {
        return self::select('id', 'name')
            ->whereIn('id', $categories)
            ->get();
    }

    public function delProduct($id)
    {
        return self::where('id', $id)->delete();
    }

    public function getFiltterTags()
    {
        return self::get();
    }
    public function getProductTypeBySlug($slug)
    {
        return self::where('slug', $slug)->first();
    }
}
