<?php

namespace App\Providers;

use App\Models\Category;
use App\Models\productType;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Paginator::useBootstrap();
        $categories = Category::all();
        $tags       = productType::all();

        View::share([
            'categories' => $categories,
            'global_tags'       => $tags
        ]);
    }
}
