<?php

namespace App\Services;

use Google\Client;
use Google\Service\Sheets;

class GoogleSheetsService
{
    protected $client;
    protected $service;
    protected $spreadsheetId;

    public function __construct()
    {

        $this->spreadsheetId = config('googlesheet.google_sheets.spreadsheet_id');
        $credentialsPath = config('googlesheet.google_sheets.credentials_path');


        $this->client = new Client();
        $this->client->setAuthConfig(storage_path($credentialsPath));
        $this->client->addScope(Sheets::SPREADSHEETS);
        $this->service = new Sheets($this->client);
    }

    /**
     * Get data from the Google Sheet.
     *
     * @param string $range The range of cells to retrieve (e.g., "Sheet1!A1:D10")
     * @return array The data from the sheet
     */
    public function getSheetData($range)
    {
        $response = $this->service->spreadsheets_values->get($this->spreadsheetId, $range);
        return $response->getValues();
    }

    /**
     * Update data in the Google Sheet.
     *
     * @param string $range The range of cells to update (e.g., "Sheet1!A1:D10")
     * @param array $values The data to be updated
     * @return mixed The update result
     */
    public function updateSheetData($range, $values)
    {
        $body = new \Google\Service\Sheets\ValueRange(['values' => $values]);
        $params = ['valueInputOption' => 'RAW'];
        return $this->service->spreadsheets_values->update($this->spreadsheetId, $range, $body, $params);
    }
}
