<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('uid')->nullable();
            $table->string('google_id')->unique()->nullable();
            $table->string('name')->nullable();
            $table->string('phone', 20)->nullable();
            $table->string('email')->nullable();
            $table->string('address')->nullable();
            $table->string('username')->nullable();
            $table->double('latitude')->nullable();
            $table->double('longitude')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->timestamp('phone_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->string('profile_picture')->nullable();
            $table->datetime('last_logged_at')->nullable();
            $table->integer('otp')->nullable();
            $table->integer('role_id');
            $table->datetime('opt_updated_at')->nullable();
            $table->string('firebase_token')->nullable();
            $table->boolean('is_active')->nullable();
            $table->boolean('otp_verified')->nullable();
            $table->decimal('wallet_balace_amount', 10, 2)->nullable();
            $table->datetime('is_vendor')->nullable();
            $table->datetime('is_reseller')->nullable();
            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
