<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('items', function (Blueprint $table) {
            $table->increments('id');
            $table->string('sku')->nullable();
            $table->string('uid')->nullable();
            $table->text('slug')->nullable();
            $table->string('name')->nullable();
            $table->text('descriptions')->nullable();
            $table->text('specification')->nullable();
            $table->text('features')->nullable();
            $table->string('image')->nullable();
            $table->decimal('price', 10, 2)->nullable()->default('0.00'); 
            $table->decimal('mrp', 10, 2)->nullable()->default('0.00'); 
            $table->integer('parent_id')->nullable();
            $table->string('color')->nullable();
            $table->string('size')->nullable();
            $table->integer('vendor_id')->nullable();
            $table->boolean('is_offer')->nullable()->comment = '1 With Pot , 2 Without Pot';
            $table->boolean('stock')->default(1)->comment = '1 Available , 0 Out of Stock';
            $table->datetime('is_verified')->nullable()->comment = 'Not null: Verified , null: Unverified';
            $table->datetime('is_draft')->nullable()->comment = 'Not null: Delivery charge applied , null: No delivery charge';
            $table->timestamps();
            $table->softDeletes();



        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('items');
    }
}


