<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserAddressesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_addresses', function (Blueprint $table) {
             $table->increments('id');
            $table->integer('user_id')->nullable();
            $table->string('contact_name')->nullable();
            $table->string('house_name')->nullable();
            $table->string('landmark')->nullable();
            $table->string('city')->nullable();
            $table->string('mobile_number')->nullable();
            $table->string('email')->nullable();
            $table->integer('pincode')->nullable();
            $table->integer('state_id')->nullable();
            $table->integer('country_id')->nullable();
            $table->integer('address_type_id')->nullable();
            $table->boolean('is_primary')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_addresses');
    }
}
