<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->increments('id');
            $table->string('uid')->nullable();
            $table->integer('reseller_id')->nullable();
            $table->string('invoice_number')->nullable();
            $table->text('address')->nullable();
            $table->integer('total_quantity')->nullable();
            $table->decimal('total_cost', 10, 2)->nullable();
            $table->integer('coupon_id')->nullable(); 
            $table->decimal('discount_cost', 10, 2)->nullable(); 
            $table->decimal('shipping_cost', 10, 2)->nullable(); 
            $table->decimal('commission', 10, 2)->nullable(); 
            $table->decimal('grand_total', 10, 2)->default(0.00); 
            $table->integer('order_status_id')->default(1);
            $table->integer('payment_option_id')->nullable();
            $table->integer('payment_id')->nullable();
            $table->string('invoice_pdf_src')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
