<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderResponsesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_responses', function (Blueprint $table) {
            $table->increments('id');
            $table->string('order_uuid')->nullable();
            $table->integer('order_id')->nullable();
            $table->integer('user_id')->nullable();

            $table->boolean('is_success')->nullable();
            $table->json('response')->nullable();
           

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_responses');
    }
}
