<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVendorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendors', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->nullable();
            $table->text('address')->nullable();
            $table->text('profile_image')->nullable();
            $table->integer('user_id')->nullable();
            $table->string('phone',20)->nullable();
            $table->string('whatsapp_no',20)->nullable();
            $table->integer('pincode')->nullable();
            $table->string('email')->unique();
            $table->boolean('is_active')->nullable();
            $table->string('gst')->nullable();
            $table->string('account_name')->nullable();
            $table->string('account_number')->nullable();
            $table->string('ifsc')->nullable();
            $table->string('upi_id')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('branch_name')->nullable();
            $table->datetime('is_approve')->nullable();
            $table->date('is_verified_condition')->nullable();
            // $table->boolean('is_tc')->default(1);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendors');
    }
}
