<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('google_sheets', function (Blueprint $table) {
            $table->id();
            $table->string('sku')->unique();
            $table->string('title');
            $table->text('description')->nullable();
            $table->decimal('mrp', 10, 2);
            $table->decimal('price', 10, 2);
            $table->string('image')->nullable();
            $table->string('gallery1')->nullable();
            $table->string('gallery2')->nullable();
            $table->string('gallery3')->nullable();
            $table->string('gallery4')->nullable();
            $table->string('feature1')->nullable();
            $table->string('feature2')->nullable();
            $table->string('feature3')->nullable();
            $table->string('feature4')->nullable();
            $table->string('feature5')->nullable();
            $table->text('product_specification')->nullable();
            $table->text('author')->nullable();
            $table->text('category')->nullable();
            $table->text('tags')->nullable();
            $table->text('language')->nullable();
            $table->text('stock')->nullable();
            $table->text('is_completed')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('google_sheets');
    }
};
