function Authors() {
    this.data = {};
    this.element = '';
    this.colspan = 5;
    this.listingContainer = $('#authors-content');
    this.pagination = $('.pagination');
    this.limit = 20;
    this.page = 1;

}

Authors.prototype.init = function () {

};

Authors.prototype.fetchDataFailure = function (response) {
    console.log(response);
};




Authors.prototype.getAuthors = function () {

    var formData = new FormData();
    formData.append('limit', author.limit);
    formData.append('page', author.page);
    // formData.append("filter[search]", $('#search').val() );
    var successCallback = author.categoryFetchDataSuccess;
    var failureCallback = author.fetchDataFailure;
    app.ajaxRequest('/admin/get-author-list', 'POST', formData, successCallback, failureCallback, false);
}

Authors.prototype.categoryFetchDataSuccess = function (response) {
    author.listingContainer.html("");
    author.pagination.html("");
    if (response.data.results == undefined || response.data.results.data.length == 0) {
        author.listingContainer.append('<tr><td colspan="5" class="text-center">Authors not found.</td></tr>');
    }
    else {
        var i = (response.data.results.current_page - 1) * 20 + 1;
        $.each(response.data.results.data, function (key, author_data) {
            author.listingContainer.append(
                '<tr id="' + author_data.id + '">' +
                "<td>" +
                (i + key) +
                "</td>" +
                '<td>' +
                author_data.name +
                '</td>' +

                '<td>' +
                author_data.bio +
                '</td>' +
                '<td>' +
                '<img src="' + author_data.image + '" style="width:50px; border-radius: 55%;" class="img-fluid" alt="banner image"/>' +
                '</td>' +

                '<td>' +
                '<div class="btn-group btn-group-sm ">' +
                '<button type="button" data-id="' + author_data.id + '" class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button>' +
                '<button type="button" data-id="' + author_data.id + '" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>' +
                '</div>' +
                '</td>' +
                '</tr>')
        });

        author.pagination.html(response.data.link);
    }


};

Authors.prototype.getSingleCategory = function (id) {
    var formData = new FormData();
    formData.append('id', id);
    var successCallback = author.singleCategoryFetchDataSuccess;
    var failureCallback = author.fetchDataFailure;
    app.ajaxRequest('/admin/get-single-category', 'POST', formData, successCallback, failureCallback, false);
}


Authors.prototype.singleCategoryFetchDataSuccess = function (response) {

    $("#id").val(response.data.category.id);
    $("#name").val(response.data.category.name);
    $("#create-modal-label").html("Update  Category");
    $(".create-submit-btn").html("Update");
    $("#create-modal").modal("show");
}



Authors.prototype.deleteAuthor = function (id) {
    var formData = new FormData();
    formData.append('id', id);
    var successCallback = author.deleteAuthorFetchDataSuccess;
    var failureCallback = author.fetchDataFailure;
    app.ajaxRequest('/admin/delete-author', 'POST', formData, successCallback, failureCallback, false);
}


Authors.prototype.deleteAuthorFetchDataSuccess = function (response) {
    $(".delete-button").attr("disabled", false).val("Delete");
    if (response.success == true) {
        author.getAuthors();
        swal({
            title: 'Success!',
            text: 'Author Deleted!',
            imageHeight: 30,
            animation: false
        });
    }
    else {
        swal({
            title: 'Info!',
            text: response.message,
            type: 'info',
            imageHeight: 30,
            animation: false
        });
    }


};

Authors.prototype.getAuthor = function (id) {
    var formData = new FormData();
    formData.append('id', id);
    var successCallback = author.singleAuthorFetchDataSuccess;
    var failureCallback = author.fetchDataFailure;
    app.ajaxRequest('/admin/get-author-data', 'POST', formData, successCallback, failureCallback, false);
}

Authors.prototype.singleAuthorFetchDataSuccess = function (response) {

    $("#id").val(response.data.author.id);
    $("#name").val(response.data.author.name);
    $("#bio").val(response.data.author.bio);
    $("#image-view").attr('src', response.data.author.image);
    $("#image-label").html("Choose file");
    $("#create-modal-label").html("Update Author");
    $(".create-submit-btn").html("Update author");
    $("#create-modal").modal("show");
}

Authors.prototype.updateAuthor = function (id) {
    $(".create-submit-btn").attr("disabled", false).val("Loading");
    var formData = image.formData;
    formData.append('id', id);
    var successCallback = author.updateAuthorFetchDataSuccess;
    var failureCallback = author.fetchDataFailure;
    app.ajaxRequest('/admin/update-author', 'POST', formData, successCallback, failureCallback, false);
}

Authors.prototype.updateAuthorFetchDataSuccess = function (response) {
    $(".create-submit-btn").attr("disabled", false).val("Update");
    $("#create-modal-label").html("Update Banner");
    $(".create-submit-btn").html("Update");
    if (response.success == true) {
        swal({
            title: 'Success!',
            text: ' Author updated!',
            imageHeight: 30,
            animation: false
        });
        $("#id").val("");
        $("#name").val("");
        $("#image").val("");
        $("#create-modal").modal("hide");

        author.getAuthors();
    }
    else {
        app.error(response.message)
    }

};

var author = new Authors();
jQuery(function () {

    app.validate();
    author.listingContainer.html(app.generateLoader(author.colspan));
    author.getAuthors();

    $(document).find(".pagination").on("click", "a", function (event) {
        event.preventDefault();
        author.page = $(this).attr('href').split('page=')[1];
        author.getAuthors();

    })

    $(document).on("click", ".status-button ", function (event) {

        var id = $(this).data('id')
        category.changeStatus(id);
    });

    $(document).on("click", ".delete-button ", function (event) {
        event.preventDefault();
        var id = $(this).data('id')
        swal({
            title: 'Are you sure?',
            text: 'The selected author will be deleted!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'No, keep it'
        }).then((result) => {
            if (id) {
                author.deleteAuthor(id);
            } else {
                swal(
                    'Cancelled',
                    'Your data is safe :)',
                    'error'
                )
            }
        })
    });


    $(document).on("click", ".edit-button ", function (event) {
        var id = $(this).data('id')
        author.getAuthor(id);
    });


    $("#create-form").submit(function (event) {
        event.preventDefault();
        event.stopPropagation();
        image.formData = new FormData(this);
        var id = $("#id").val();
        if (id.length == 0 || id == '') {
            // image.createBannerImage();
        }
        else {
            author.updateAuthor(id);
        }
    })



});