function Blog() {
    this.listingContainer = $("#blog_content");
    this.limit = 20;
    this.page = 1;
    this.pagination = $(".pagination");
  }
  Blog.prototype.getBlog = function () {
    var formData = new FormData();
    formData.append("limit", blog.limit);
    formData.append("page", blog.page);
    var successCallback = blog.blogFetchDataSuccess;
    var failureCallback = blog.fetchDataFailure;
    app.ajaxRequest(
      "/admin/list-blog",
      "POST",
      formData,
      successCallback,
      failureCallback,
      false
    );
  };
  Blog.prototype.fetchDataFailure = function (response) {
    console.log(response);
  };
  Blog.prototype.blogFetchDataSuccess = function (response) {
    blog.listingContainer.html("");
    blog.pagination.html("");
    if (response.data.results.data == undefined || response.data.results.data.length == 0) {
        blog.listingContainer.append(
        '<tr><td colspan="9" class="text-center">Blog not found.</td></tr>'
      );
    } else {
      var i = (response.data.results.current_page - 1) * 20 + 1;
      $.each(response.data.results.data, function (key, blog_data) {
        blog.listingContainer.append(
          '<tr id="' +
          blog_data.id +
            '">' +
            "<td>" +
            (i + key) +
            "</td>" +
            "<td>" +
            blog_data.title+
            "</td>" +
            "<td>" +
            blog_data.description +
            "</td>" +
            "<td>" +
          '<img src="' +
          blog_data.image +
          '" width="40" height="40"> ' +
          "</td>" +
           
           
            "<td>" +
            '<div class="btn-group btn-group-sm ">' +
            '<a href ="/admin/blog/' +
            btoa(blog_data.id) +
            '/edit" data-toggle="tooltip" title="Edit Category" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>' +
            '<button type="button" data-id="' +
           btoa( blog_data.id) +
            '" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>' +
            "</div>" +
            "</td>" +
            "</tr>"
        );
      });
      blog.pagination.html(response.data.link);
    }
  };
  Blog.prototype.deleteBlog =function(id){
  var formData    = new FormData ();
  formData.append('id',id)
  var successCallback = blog.deleteBlogFetchDataSuccess;
    var failureCallback = blog.fetchDataFailure;
    app.ajaxRequest(
      "/admin/delete-blog",
      "POST",
      formData,
      successCallback,
      failureCallback,
      false
    );
  }
  Blog.prototype.deleteBlogFetchDataSuccess=function(response){
    $(".delete-button").attr("disabled", false).val("Update");
    if (response.success == true) {
       blog.getBlog();
        swal({
            title: "Success!",
            text: "Blog deleted!",
            imageHeight: 30,
            animation: false,
        });
    } else {
        swal({
            title: "Info!",
            text: response.message,
            type: "info",
            imageHeight: 30,
            animation: false,
        });
    }
  }
  var blog = new Blog();
  jQuery(function () {
    blog.getBlog();
    $(document)
      .find(".pagination")
      .on("click", "a", function (event) {
        event.preventDefault();
        blog.page = $(this).attr("href").split("page=")[1];
        blog.getBlog();
      });
  
  
  });
  $(document).on("click", ".delete-button ", function (event) {
     
    event.preventDefault();
    var id = $(this).data("id");
    swal({
        title: "Are you sure?",
        text: "The selected Blog will be deleted!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, keep it",
    }).then((result) => {
        if (id) {
            blog.deleteBlog(id);
        } else {
            swal("Cancelled", "Your data is safe :)", "error");
        }
    });
  });
  