function Booking() {
  this.listingContainer = $("#booking_content");
  this.limit = 20;
  this.page = 1;
  this.pagination = $(".pagination");
  
}
Booking.prototype.getBooking = function () {
  
  var formData = new FormData();
  formData.append("limit", booking.limit);
  formData.append("page", booking.page);
  formData.append("search",$("#search").val())
  var successCallback = booking.bookingFetchDataSuccess;
  var failureCallback = booking.fetchDataFailure;
  app.ajaxRequest(
    "/admin/list-booking",
    "POST",
    formData,
    successCallback,
    failureCallback,
    false
  );
};
Booking.prototype.fetchDataFailure = function (response) {
  console.log(response);
};
Booking.prototype.bookingFetchDataSuccess = function (response) {
  booking.listingContainer.html("");
  booking.pagination.html("");
  if (
    response.data.results.data == undefined ||
    response.data.results.data.length == 0
  ) {
    booking.listingContainer.append(
      '<tr><td colspan="6" class="text-center">Booking not found.</td></tr>'
    );
  } else {
    var i = (response.data.results.current_page - 1) * 20 + 1;
    $.each(response.data.results.data, function (key, booking_data) {
      booking.listingContainer.append(
        '<tr id="' +
          booking_data.id +
          '">' +
          "<td>" +
          (i + key) +
          "</td>" +
          "<td>" +
          booking_data.user.name +
          "</td>" +
          "<td>" +
          booking_data.package.title +
          "</td>" +
          "<td>" +
          booking_data.payment_type.title +
          "</td>" +
          (booking_data.status_id == 1
            ? "<td style='color: green;'>"
            : "<td style='color: red;'>") +
          booking_data.status.title +
          "</td>" +
          "<td>" +
          '<div class="btn-group btn-group-sm ">' +
          '<a href ="/admin/booking/' +
          btoa(booking_data.id) +
          '/details" data-toggle="tooltip" title="Booking Details" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>' +
          "</td>" +
          "</tr>"
      );
    });
    booking.pagination.html(response.data.link);
    // console.log( package.pagination);
  }
};
Booking.prototype.deleteFlight = function (id) {
  var formData = new FormData();
  formData.append("id", id);
  var successCallback = flight.deleteFlightFetchDataSuccess;
  var failureCallback = flight.fetchDataFailure;
  app.ajaxRequest(
    "/admin/delete-flight",
    "POST",
    formData,
    successCallback,
    failureCallback,
    false
  );
};
Booking.prototype.deleteFlightFetchDataSuccess = function (response) {
  $(".delete-button").attr("disabled", false).val("Update");
  if (response.success == true) {
    flight.getFlight();
    swal({
      title: "Success!",
      text: "Flight deleted!",
      imageHeight: 30,
      animation: false,
    });
  } else {
    swal({
      title: "Info!",
      text: response.message,
      type: "info",
      imageHeight: 30,
      animation: false,
    });
  }
};

var booking = new Booking();
jQuery(function () {
  booking.getBooking();
  $(document)
    .find(".pagination")
    .on("click", "a", function (event) {
      event.preventDefault();
      booking.page = $(this).attr("href").split("page=")[1];
      booking.getFlight();
    });
   
});
$('#search').change(function (e){
  booking.getBooking()
});



$(document).on("click", ".delete-button ", function (event) {
  event.preventDefault();
  var id = $(this).data("id");
  swal({
    title: "Are you sure?",
    text: "The selected Flight will be deleted!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Yes, delete it!",
    cancelButtonText: "No, keep it",
  }).then((result) => {
    if (id) {
      booking.deleteFlight(id);
    } else {
      swal("Cancelled", "Your data is safe :)", "error");
    }
  });
});
