function Category() {
  this.data = {};
  this.element = '';
  this.colspan = 5;
  this.listingContainer = $('#category-content');
  this.pagination = $('.pagination');
  this.limit = 10;
  this.page = 1;

}

Category.prototype.init = function () {

};

Category.prototype.fetchDataFailure = function (response) {
  console.log(response);
};




Category.prototype.getCategory = function () {

  var formData = new FormData();
  formData.append('limit', category.limit);
  formData.append('page', category.page);
  // formData.append("filter[search]", $('#search').val() );
  var successCallback = category.categoryFetchDataSuccess;
  var failureCallback = category.fetchDataFailure;
  app.ajaxRequest('/admin/get-category-list', 'POST', formData, successCallback, failureCallback, false);
}

Category.prototype.categoryFetchDataSuccess = function (response) {
  category.listingContainer.html("");
  category.pagination.html("");
  if (response.data.results == undefined || response.data.results.data.length == 0) {
    category.listingContainer.append('<tr><td colspan="5" class="text-center">Category not found.</td></tr>');
  }
  else {
    $.each(response.data.results.data, function (key, category_data) {
      var status = (category_data.is_home == true) ? '<button type="button" data-id="' + category_data.id + '" class="status-button btn btn-sm" style="float: none; margin: 5px; background-color: #4F7942; color: #fff">Home Active</button>' : '<button type="button" data-id="' + category_data.id + '" class="status-button btn btn-sm btn-warning" style="float: none; margin: 5px;">Home Inactive</button>';
      category.listingContainer.append(
        '<tr id="' + category_data.id + '">' +
        '<td>' +
        category_data.name +
        '</td>' +
        '<td>' +
        '<img src="' + category_data.logo + '" style="width:35px;" class="img-fluid" alt="logo image"/>' +
        '</td>' +
        '<td>' +
        '<img src="' + category_data.banner + '" style="width:35px;" class="img-fluid" alt="banner image"/>' +
        '</td>' +
        '<td>' +
        category_data.slug +
        '</td>' +
        '<td>' + (category_data.parent ? category_data.parent.name : '-') + '</td>' +
        '<td>' +
        ((category_data.is_active == 1) ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-danger">Inactive</span>') +
        '</td>' +
        '<td>' +
        '<div class="btn-group btn-group-sm ">' +
        '<a href ="/admin/category/' + btoa(category_data.id) + '/edit"><button type="button" data-id="" class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>' +
        status +
        '</div>' +
        '</td>' +

        '</tr>')
    });

    category.pagination.html(response.data.link);
  }


};

Category.prototype.getSingleCategory = function (id) {
  var formData = new FormData();
  formData.append('id', id);
  var successCallback = category.singleCategoryFetchDataSuccess;
  var failureCallback = category.fetchDataFailure;
  app.ajaxRequest('/admin/get-single-category', 'POST', formData, successCallback, failureCallback, false);
}


Category.prototype.singleCategoryFetchDataSuccess = function (response) {

  $("#id").val(response.data.category.id);
  $("#name").val(response.data.category.name);
  $("#create-modal-label").html("Update  Category");
  $(".create-submit-btn").html("Update");
  $("#create-modal").modal("show");
}

Category.prototype.changeStatus = function (id) {
  var formData = new FormData();
  formData.append('id', id);
  var successCallback = category.changeStatusFetchDataSuccess;
  var failureCallback = category.fetchDataFailure;
  app.ajaxRequest('/admin/change-home-status', 'POST', formData, successCallback, failureCallback, false);
}

Category.prototype.changeStatusFetchDataSuccess = function (response) {

  $(".status-button").attr("disabled", false).val("Update");
  if (response.success == true) {
    category.getCategory();
    swal({
      title: 'Success!',
      text: 'Home Status Changed!',
      imageHeight: 30,
      animation: false
    });
  }
  else {
    swal({
      title: 'Info!',
      text: response.message,
      type: 'info',
      imageHeight: 30,
      animation: false
    });
  }


};

var category = new Category();



jQuery(function () {

  app.validate();
  category.listingContainer.html(app.generateLoader(category.colspan));
  category.getCategory();

  $(document).find(".pagination").on("click", "a", function (event) {
    event.preventDefault();
    category.page = $(this).attr('href').split('page=')[1];
    category.getCategory();

  })

  $(document).on("click", ".status-button ", function (event) {

    var id = $(this).data('id')
    category.changeStatus(id);
  });



});