function ContactUs(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 4;
  this.listingContainer   = $('#contact-us-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
}


ContactUs.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




ContactUs.prototype.getContactUs = function()
{
    var formData = new FormData(); 
    formData.append('limit', contact.limit );
    formData.append('page', contact.page );
    formData.append("search", $('#search').val() );
    var successCallback = contact.contactFetchDataSuccess;
    var failureCallback = contact.fetchDataFailure;
    app.ajaxRequest('/admin/get-contact-us-list','POST',formData,successCallback,failureCallback,false);
}

ContactUs.prototype.contactFetchDataSuccess = function(response) 
{
    
    contact.listingContainer.html("");
    contact.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       contact.listingContainer.append('<tr><td colspan="'+contact.colspan+'" class="text-center">Contact Us not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,contact_us)
      {
        var status = (contact_us.status  == 0) ? '<button type="button" data-id="'+contact_us.id+'" class="status-button btn btn-sm btn-success" style="float: none; margin: 5px;">Verify</button>' : '' ;
          contact.listingContainer.append(
              '<tr id="'+contact_us.id+'">'+
              
              '<td >'+
              contact_us.user.name+
              '</td>'+
               '<td>'+
              contact_us.user.phone+
              '</td>'+
              '<td>'+
              contact_us.subject+
              '</td>'+
             '<td>'+
              contact_us.message+
              '</td>'+
              '<td>'+
              ((contact_us.status  == 0) ? '<span class="badge badge-danger">Not Verified</span>' : '<span class="badge badge-success">Verified</span>' )+
              '</td>'+
              '<td>'+
                  '<div class="btn-group btn-group-sm ">'+
                  status+
                  '</div>'+
              '</td>'+
          '</tr>')
        });
        
        contact.pagination.html(response.data.link);
    }
   

};


var contact = new ContactUs();

ContactUs.prototype.changeStatus = function(id)
{
    var formData        = new FormData(); 
    formData.append('id', id );
    var successCallback = contact.changeStatusFetchDataSuccess;
    var failureCallback = contact.fetchDataFailure;
    app.ajaxRequest('/admin/contact-us-change-status','POST',formData,successCallback,failureCallback,false);
}

ContactUs.prototype.changeStatusFetchDataSuccess = function(response) 
{

   $(".status-button").attr("disabled", false).val("Update");
    if(response.success == true)
    {
        contact.getContactUs();
        swal({
           title: 'Success!',
            text: 'Active Status Changed!',
            imageHeight: 30,
            animation: false
        });
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};

jQuery(function () 
{
    
    app.validate();
    contact.listingContainer.html(app.generateLoader(contact.colspan ));
    contact.getContactUs();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      contact.page = $(this).attr('href').split('page=')[1];
      contact.getContactUs();
     
    })

    
    

    $("#search").change(function(event)
    {
      event.preventDefault();
      contact.getContactUs();
    });

    $(document).on("click", ".status-button ",function(event){

      var id = $(this).data('id') 
      contact.changeStatus(id);
    });
   
});