function Coupon(){
  this.data               = {};
  this.element            = '';
  this.colspan            = 10;
  this.listingContainer   = $('#coupon-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
}


Coupon.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Coupon.prototype.getCoupon = function()
{

    var formData = new FormData(); 
    formData.append('limit', coupon.limit );
    formData.append('page', coupon.page );
    formData.append("search", $('#search').val() );
    var successCallback = coupon.couponFetchDataSuccess;
    var failureCallback = coupon.fetchDataFailure;
    app.ajaxRequest('/admin/coupon-list','POST',formData,successCallback,failureCallback,false);
}

Coupon.prototype.couponFetchDataSuccess = function(response) 
{
    
    coupon.listingContainer.html("");
    coupon.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       coupon.listingContainer.append('<tr><td colspan="10" class="text-center">Coupon not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,coupon_data)
      {
        coupon.listingContainer.append(
              '<tr>'+
              '<td>'+
              coupon_data.name+
              '</td>'+
               '<td>'+
               coupon_data.code+
              '</td>'+
              '<td>'+
              coupon_data.expiry_date+
              '</td>'+
              '<td>'+
              '₹'+coupon_data.minimum_order+
              '</td>'+
              '<td>'+
              coupon_data.discount_percentage+"%"+
              '</td>'+
              '<td>'+
              coupon_data.discount_amount+
              '</td>'+
              '<td>'+
              coupon_data.total_count+
              '</td>'+
              '<td>'+
              coupon_data.remaining_count+
              '</td>'+
               '<td>'+
              ((coupon_data.is_active  == true) ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-danger">Inactive</span>' )+
              '</td>'+

             '<td>'+
                   '<div class="btn-group btn-group-sm ">'+
                     '<a href ="/admin/coupon/'+btoa(coupon_data.id)+'/edit"><button type="button" data-id="" class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>'+
                     '<a href ="/admin/get-coupon-list/'+btoa(coupon_data.id)+'/users"><button type="button" data-id="" class="info-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="ti-user"></span></button></a>'+
                     '<button type="button" data-id="'+coupon_data.id+'" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>'+


                  '</div>'+
              '</td>'+
             
          '</tr>')
        });
        
        coupon.pagination.html(response.data.link);
    }
   

};
Coupon.prototype.changeStatus = function(id)
{
    var formData        = new FormData(); 
    formData.append('id', id );
    var successCallback = coupon.changeStatusFetchDataSuccess;
    var failureCallback = coupon.fetchDataFailure;
    app.ajaxRequest('/admin/change-coupon-status','POST',formData,successCallback,failureCallback,false);
}

Coupon.prototype.changeStatusFetchDataSuccess = function(response) 
{

   $(".status-button").attr("disabled", false).val("Update");
    if(response.success == true)
    {
        coupon.getCoupon();
        swal({
           title: 'Success!',
            text: 'Coupon Status Changed!',
            imageHeight: 30,
            animation: false
        });
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};

Coupon.prototype.deleteCoupon = function(id)
{
    var formData        = new FormData(); 
    formData.append('id', id );
    var successCallback = coupon.deleteCouponFetchDataSuccess;
    var failureCallback = coupon.fetchDataFailure;
    app.ajaxRequest('/admin/delete-coupon','POST',formData,successCallback,failureCallback,false);
}

Coupon.prototype.deleteCouponFetchDataSuccess = function(response) 
{

   $(".delete-button").attr("disabled", false).val("Delete");
    if(response.success == true)
    {
        coupon.getCoupon();
        swal({
           title: 'Success!',
            text: 'Coupon Deleted!',
            imageHeight: 30,
            animation: false
        });
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};

var coupon = new Coupon();



jQuery(function () 
{
    
    app.validate();
    app.setZipCodeMask();
    coupon.listingContainer.html(app.generateLoader(coupon.colspan ));
    coupon.getCoupon();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      coupon.page = $(this).attr('href').split('page=')[1];
      coupon.getCoupon();
     
    })

    $(".right-action").click(function(){

      window.location = '/admin/create-coupon'

    });
    

    $(document).on("click", ".edit-button ",function(event){

      var id = $(this).data('id') 
      coupon.getSingleCoupon(id);
    });

    $('#create-modal').on('hidden.bs.modal', function () {
      $("#id").val("");
      $("#name").val("");
      $("#pincode").val("");
      $("#create-modal-label").html("Create  Service Location");
      $(".create-submit-btn").html("Create");
    });

    $("#create-form").submit(function(event){
      event.preventDefault();
      var id =  $("#id").val();
      if(id.length == 0 || id == '')
      {
        coupon.createCoupon();
      }
      else
      {
        coupon.updateCoupon(id);
      }
    });

     $("#search").change(function(event)
    {
      event.preventDefault();
     coupon.getCoupon();
    });

    $(document).on("click", ".delete-button ",function(event){

      event.preventDefault();
      var id = $(this).data('id') 
      swal({
        title: 'Are you sure?',
        text: 'The selected Coupon will be deleted!',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'No, keep it'
      }).then((result) => {
        if (id) {
          coupon.deleteCoupon(id);
        } else {
          swal(
            'Cancelled',
            'Your data is safe :)',
            'error'
          )
        }
      })  
       
      });

    $(document).on("click", ".status-button ",function(event){

      var id = $(this).data('id') 
      coupon.changeStatus(id);
    });

   
});