function Customers() {
  this.data = {};
  this.element = '';
  this.colspan = 3;
  this.listingContainer = $('#customer-content');
  this.pagination = $('.pagination');
  this.limit = 10;
  this.page = 1;
}


Customers.prototype.fetchDataFailure = function (response) {
  console.log(response);
};




Customers.prototype.getCustomers = function () {
  var formData = new FormData();
  formData.append('limit', customer.limit);
  formData.append('page', customer.page);
  formData.append("search", $('#search').val());
  var successCallback = customer.customerFetchDataSuccess;
  var failureCallback = customer.fetchDataFailure;
  app.ajaxRequest('/admin/get-customers-list', 'POST', formData, successCallback, failureCallback, false);
}

Customers.prototype.customerFetchDataSuccess = function (response) {

  customer.listingContainer.html("");
  customer.pagination.html("");

  if (response.data.results == undefined || response.data.results.data.length == 0) {
    customer.listingContainer.append('<tr><td colspan="5" class="text-center">Customers not found.</td></tr>');
  }
  else {
    var currentPage = response.data.results.current_page;
    var perPage = response.data.results.per_page;
    $.each(response.data.results.data, function (key, customer_boy) {
      var slNo = ((currentPage - 1) * perPage) + (key + 1);

      var status = (customer_boy.is_active == true) ? '<button type="button" data-id="' + customer_boy.id + '" class="status-button btn btn-sm btn-danger" style="float: none; margin: 5px;">Deactivate</button>' : '<button type="button" data-id="' + customer_boy.id + '" class="status-button btn btn-sm btn-success" style="float: none; margin: 5px;">Activate</button>';
      customer.listingContainer.append(
        '<tr id="' + customer_boy.id + '">' +
        '<td>' + slNo + '</td>' +
        '<td >' +
        customer_boy.name +
        '</td>' +
        '<td>' +
        customer_boy.phone +
        '</td>' +
        '<td>' +
        customer_boy.email +
        '</td>' +
        '<td class="text-center">' +
        ((customer_boy.is_active == 1) ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-danger">Inactive</span>') +
        '</td>' +
        '<td style="font-size:1.875rem" class="text-center">' +
        ((customer_boy.is_vendor != null) ? '✔' : '✗') +
        '</td>' +
        '<td>' +
        '<div class="btn-group btn-group-sm ">' +
        '<a href="/admin/customers/' + btoa(customer_boy.id) + '/change-password"><button type="button"  class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="fa fa-cog"></span></button></a>' +
        '</div>' +
        '</td>' +

        '</tr>')
    });

    customer.pagination.html(response.data.link);
  }


};

Customers.prototype.changeStatus = function (id) {
  var formData = new FormData();
  formData.append('id', id);
  var successCallback = customer.changeStatusFetchDataSuccess;
  var failureCallback = customer.fetchDataFailure;
  app.ajaxRequest('/admin/customer-change-status', 'POST', formData, successCallback, failureCallback, false);
}

Customers.prototype.changeStatusFetchDataSuccess = function (response) {

  $(".status-button").attr("disabled", false).val("Update");
  if (response.success == true) {
    customer.getCustomers();
    swal({
      title: 'Success!',
      text: 'Active Status Changed!',
      imageHeight: 30,
      animation: false
    });
  }
  else {
    swal({
      title: 'Info!',
      text: response.message,
      type: 'info',
      imageHeight: 30,
      animation: false
    });
  }


};


var customer = new Customers();



jQuery(function () {

  app.validate();
  customer.listingContainer.html(app.generateLoader(customer.colspan));
  customer.getCustomers();

  $(document).find(".pagination").on("click", "a", function (event) {
    event.preventDefault();
    customer.page = $(this).attr('href').split('page=')[1];
    customer.getCustomers();

  })




  $("#search").change(function (event) {
    event.preventDefault();
    customer.getCustomers();
  });

  $(document).on("click", ".status-button ", function (event) {

    var id = $(this).data('id')
    customer.changeStatus(id);
  });


});