function DeliveryCharge(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 3;
  this.listingContainer   = $('#delivery-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
  this.item_id            = $('#id').val();
}


DeliveryCharge.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




DeliveryCharge.prototype.getDeliveryCharge = function()
{
    var formData = new FormData(); 
    formData.append('limit', delivery.limit );
    formData.append('page', delivery.page );
    formData.append('id', delivery.item_id );
    var successCallback = delivery.deliveryFetchDataSuccess;
    var failureCallback = delivery.fetchDataFailure;
    app.ajaxRequest('/admin/get-product-delivery-charge-list','POST',formData,successCallback,failureCallback,false);
}

DeliveryCharge.prototype.deliveryFetchDataSuccess = function(response) 
{
    
    delivery.listingContainer.html("");
    delivery.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       delivery.listingContainer.append('<tr><td colspan="3" class="text-center">No Data.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,delivery_charge)
      {

          delivery.listingContainer.append(
              '<tr id="'+delivery_charge.id+'">'+
              
              '<td>'+
              delivery_charge.state.name+
              '</td>'+
              '<td>'+
              delivery_charge.delivery_charge+
              '</td>'+
             '<td>'+
                   '<div class="btn-group btn-group-sm ">'+
                   '<button type="button" data-id="'+delivery_charge.id+'" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button>'+
                   '<button type="button" data-id="'+delivery_charge.id+'" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>'+
                  '</div>'+
              '</td>'+
             
          '</tr>')
        });
        
        delivery.pagination.html(response.data.link);
    }
   

};

DeliveryCharge.prototype.getSingleDeliveryCharge = function(id)
{
    var formData = new FormData(); 
    formData.append('id', id );
    var successCallback = delivery.singleDeliveryChargeFetchDataSuccess;
    var failureCallback = delivery.fetchDataFailure;
    app.ajaxRequest('/admin/get-single-product-delivery-charge','POST',formData,successCallback,failureCallback,false);
}


DeliveryCharge.prototype.singleDeliveryChargeFetchDataSuccess = function(response) 
{
    $("#data_id").val(response.data.delivery.id);
    $("#state_id").val(response.data.delivery.state_id);
    $("#delivery_charge").val(response.data.delivery.delivery_charge);
    $("#create-modal-label").html("Update Delivery Charge of "+response.data.delivery.state['name']+"");
    $(".create-submit-btn").html("Update");
    $("#create-modal").modal("show");
}

DeliveryCharge.prototype.updateDeliveryCharge = function(id)
{
    $(".create-submit-btn").attr("disabled", false).val("Loading");
    var formData = new FormData(); 
    formData.append('id', $("#data_id").val() );
    formData.append('state_id', $("#state_id").val() );
    formData.append('delivery_charge', $("#delivery_charge").val() );
    var successCallback = delivery.updateDeliveryChargeFetchDataSuccess;
    var failureCallback = delivery.fetchDataFailure;
    app.ajaxRequest('/admin/update-product-delivery-charge','POST',formData,successCallback,failureCallback,false);
}

DeliveryCharge.prototype.updateDeliveryChargeFetchDataSuccess = function(response) 
{
   
   $(".create-submit-btn").attr("disabled", false).val("Update");
    $("#data_id").val("");
    $("#state_id").val("");
    $("#delivery_charge").val("");
    $("#create-modal-label").html("Update Product Delivery Charge");
    $(".create-submit-btn").html("Update");
    $("#create-modal").modal("hide");
    swal({
        title: 'Success!',
         text: '  Product Delivery Charge updated!',
         imageHeight: 30,
         animation: false
   }).then((value) => {
        window.location = '/admin/products/'+btoa(delivery.item_id)+'/delivery-charge';
    });

};

DeliveryCharge.prototype.deleteDeliveryCharge = function(id)
{
    var formData = new FormData(); 
    formData.append('id', id );
    var successCallback = delivery.deleteDeliveryChargeFetchDataSuccess;
    var failureCallback = delivery.fetchDataFailure;
    app.ajaxRequest('/admin/delete-product-delivery-charge','POST',formData,successCallback,failureCallback,false);
}


DeliveryCharge.prototype.deleteDeliveryChargeFetchDataSuccess = function(response) 
{
  $(".delete-button").attr("disabled", false).val("Delete");
  if(response.success == true)
  {
    delivery.getDeliveryCharge();
      swal({
         title: 'Success!',
          text: 'Delivery Charge Deleted!',
          imageHeight: 30,
          animation: false
      });
  }
  else
  {
      swal({
            title: 'Info!',
            text: response.message,
            type:'info',
            imageHeight: 30,
            animation: false
      });
  }


};

var delivery = new DeliveryCharge();



jQuery(function () 
{
    
    app.validate();
    app.setZipCodeMask();
    delivery.listingContainer.html(app.generateLoader(delivery.colspan ));
    delivery.getDeliveryCharge();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      delivery.page = $(this).attr('href').split('page=')[1];
      delivery.getDeliveryCharge();
     
    }) 
});

function replaceAll(string, search, replace) 
{
  return string.split(search).join(replace);
}

$(document).on("click", ".edit-button ",function(event){

  var id = $(this).data('id') 
  delivery.getSingleDeliveryCharge(id);
});

$('#create-modal').on('hidden.bs.modal', function () {
  $("#data_id").val("");
  $("#state_id").val("");
  $("#delivery_charge").val("");
  $("#create-modal-label").html("Edit Delivery Charge");
  $(".create-submit-btn").html("Update");
});

$("#create-form").submit(function(event){
  event.preventDefault();
  var id =  $("#data_id").val();
  delivery.updateDeliveryCharge(id);

})

$(document).on("click", ".delete-button ",function(event)
{
  event.preventDefault();
  var id = $(this).data('id') 
  swal({
    title: 'Are you sure?',
    text: 'The selected Delivery Charge will be deleted!',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Yes, delete it!',
    cancelButtonText: 'No, keep it'
  }).then((result) => {
    if (id) {
      delivery.deleteDeliveryCharge(id);  
    } else {
      swal(
        'Cancelled',
        'Your data is safe :)',
        'error'
      )
    }
  }) 
});
