function Delivery(){
  this.data               = {};
  this.element            = '';
  this.colspan            = 5;
  this.listingContainer   = $('#delivery-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;

}

Delivery.prototype.init = function() 
{
  
};

Delivery.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Delivery.prototype.getDelivery = function()
{

    var formData = new FormData(); 
    formData.append('limit', delivery.limit );
    formData.append('page', delivery.page );
    var successCallback = delivery.deliveryFetchDataSuccess;
    var failureCallback = delivery.fetchDataFailure;
    app.ajaxRequest('/admin/get-delivery-partners-list','POST',formData,successCallback,failureCallback,false);
}

Delivery.prototype.deliveryFetchDataSuccess = function(response) 
{
    delivery.listingContainer.html("");
    delivery.pagination.html("");
     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       delivery.listingContainer.append('<tr><td colspan="2" class="text-center">Delivery Partner not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,delivery_data)
      {
          var delivery_link   = delivery_data.link ? delivery_data.link : "-" ;
          delivery.listingContainer.append(
              '<tr id="'+delivery_data.id+'">'+
              '<td>'+
                delivery_data.name+
              '</td>'+
              '<td>'+
              delivery_link+
              '</td>'+
             '<td>'+
                   '<div class="btn-group btn-group-sm ">'+
                   '<a href ="/admin/delivery-partners/'+btoa(delivery_data.id)+'/edit-delivery-partner"><button type="button" data-id="" class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>'+
                   '<button type="button" data-id="'+delivery_data.id+'" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>'+
                  '</div>'+
              '</td>'+
             
          '</tr>')
        });
        
        delivery.pagination.html(response.data.link);
    }
   

};

Delivery.prototype.deleteDelivery = function(id)
{
    var formData        = new FormData(); 
    formData.append('id', id );
    var successCallback = delivery.deleteDeliveryFetchDataSuccess;
    var failureCallback = delivery.fetchDataFailure;
    app.ajaxRequest('/admin/delete-delivery-partner','POST',formData,successCallback,failureCallback,false);
}

Delivery.prototype.deleteDeliveryFetchDataSuccess = function(response) 
{

   $(".delete-button").attr("disabled", false).val("Delete");
    if(response.success == true)
    {
        delivery.getDelivery();
        swal({
           title: 'Success!',
            text: 'Delivery Partner Deleted!',
            imageHeight: 30,
            animation: false
        });
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};


var delivery = new Delivery();



jQuery(function () 
{
    
    app.validate();
    delivery.listingContainer.html(app.generateLoader(delivery.colspan ));
    delivery.getDelivery();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      delivery.page = $(this).attr('href').split('page=')[1];
      delivery.getDelivery();
     
    })

    $(document).on("click", ".delete-button ",function(event){

      event.preventDefault();
        var id = $(this).data('id') 
        swal({
          title: 'Are you sure?',
          text: 'The selected Delivery Partner will be deleted!',
          icon: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Yes, delete it!',
          cancelButtonText: 'No, keep it'
        }).then((result) => {
          if (id) {
            delivery.deleteDelivery(id);
          } else {
            swal(
              'Cancelled',
              'Your data is safe :)',
              'error'
            )
          }
        })   
      
    });
});