function Product(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 3;
  this.listingContainer   = $('#draft-product-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
}


Product.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Product.prototype.getProduct = function()
{
    var formData = new FormData(); 
    formData.append('limit', product.limit );
    formData.append('page', product.page );
    formData.append("search", $('#search').val() );
    var successCallback = product.productFetchDataSuccess;
    var failureCallback = product.fetchDataFailure;
    app.ajaxRequest('/admin/get-draft-product-list','POST',formData,successCallback,failureCallback,false);
}

Product.prototype.productFetchDataSuccess = function(response) 
{
    
    product.listingContainer.html("");
    product.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       product.listingContainer.append('<tr><td colspan="7" class="text-center">Product not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,product_data)
      {
        var image = '<img src="'+product_data.image+'" class="img-fluid" width="35" alt="product">';  
        product.listingContainer.append(             
              '<tr id="'+product_data.id+'">'+
              '<td>'+image+'</td>>'+
               '<td>'+product_data.name+'</td>'+
               '<td>₹'+product_data.price.makeNumber()+'</td>'+
              //  '<td>'+product_data.category.name+'</td>'+
               '<td>'+product_data.vendor.name+'</td>'+
              //  '<td>'+product_data.product_type.name+'</td>'+
              '<td>'+
                    '<div class="button-list">'+
                    '<a href="/admin/products/'+btoa(product_data.id)+'/delivery-charge" class="btn btn-primary-rgba"><i class="feather icon-truck"></i></a>'+
                    '<a href="/admin/edit-product/'+product_data.uid+'" class="btn btn-warning-rgba"><i class="feather icon-edit-2"></i></a>'+
                    '<button type="button" data-id="'+product_data.id+'" class="delete-button btn btn-danger-rgba"><i class="feather icon-trash-2"></button>'+
                    '</div>'+
                '</td>'+
             
          '</tr>')
        });
        
        product.pagination.html(response.data.link);
    }
};


Product.prototype.changeStatus = function(id)
{
    var formData        = new FormData(); 
    formData.append('id', id );
    var successCallback = product.changeStatusFetchDataSuccess;
    var failureCallback = product.fetchDataFailure;
    app.ajaxRequest('/admin/change-draft-product-approve-status','POST',formData,successCallback,failureCallback,false);
}

Product.prototype.changeStatusFetchDataSuccess = function(response) 
{

   $(".status-button").attr("disabled", false).val("Update");
    if(response.success == true)
    {
      product.getProduct();
        swal({
           title: 'Success!',
            text: 'Product Approved!',
            imageHeight: 30,
            animation: false
        });
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};





var product = new Product();



jQuery(function () 
{
    
    app.validate();
    app.setZipCodeMask();
    product.listingContainer.html(app.generateLoader(product.colspan ));
    product.getProduct();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      product.page = $(this).attr('href').split('page=')[1];
      product.getProduct();
     
    }) 
});

function replaceAll(string, search, replace) 
{
  return string.split(search).join(replace);
}

$("#search").change(function(event)
{
  event.preventDefault();
  product.getProduct();
});



$(document).on("click", ".status-button ",function(event){

  var id = $(this).data('id') 
  product.changeStatus(id);
});