function FlightRoute(){
    this.data = {};
    this.listingContainer = $("#flight_route_content");
    this.pagination = $(".pagination");
    this.limit = 20;
    this.page = 1;
}
FlightRoute.prototype.fetchDataFailure =function(response){
    console.log(response);
}
FlightRoute.prototype.getflightRoute   =   function(){
  
  
   var formData =new FormData()
   formData.append('limit',flight_route.limit)
   formData.append('page',flight_route.page)
   var successCallback = flight_route.flightFetchDataSuccess;
   var failureCallback = flight_route.fetchDataFailure;
   app.ajaxRequest(
    "/admin/list-flight-route",
    "POST",
    formData,
    successCallback,
    failureCallback,
    false);

}
FlightRoute.prototype.flightFetchDataSuccess =function(response){
    flight_route.listingContainer.html("");
    flight_route.pagination.html("")
    if (
        response.data.results.data == undefined ||
        response.data.results.length == 0
    ) {
        flight_route.listingContainer.append(
            '<tr><td colspan="6" class="text-center">Flight Route not found.</td></tr>'
        );
    }
    else{
        var i = (response.data.results.current_page - 1) * 20 + 1;
        $.each(response.data.results.data,function(key,flight_route_data){
            flight_route.listingContainer.append(
                '<tr id="'+flight_route_data.id+'">'+
                "<td>" +
                (i + key) +
                "</td>" +
                "<td>" +
                flight_route_data.title +
                "</td>" +
                "<td>" +
                flight_route_data.description +
                "</td>" +
                "<td>" +
                flight_route_data.from_location +
                "</td>" +
                "<td>" +
                flight_route_data.to_location +
                "</td>" +
               
                '<td>'+
                     '<div class="btn-group btn-group-sm ">'+
                     '<a href ="/admin/flight-route/'+btoa(flight_route_data.id)+'/edit" data-toggle="tooltip" title="Edit Flight Route" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>'+
                     '<div class="btn-group btn-group-sm ">'+
                     '<a href ="/admin/flight-route/'+btoa(flight_route_data.id)+'/view" data-toggle="tooltip" title="View Flight Route" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-eye"></span></button></a>'+
                     '<button type="button" data-id="'+flight_route_data.id+'" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>'+
                    '</div>'+
                '</td>'+
            '</tr>')
        });
        flight_route.pagination.html(response.data.link);
        console.log(response.data.link)
   
    }
}
FlightRoute.prototype.deleteFlightRoute    =   function (id){
    var formData    = new FormData()
    formData.append('id',id)
    var successCallback = flight_route.deleteFlightRouteFetchDataSuccess;
   var failureCallback = flight_route.fetchDataFailure;
   app.ajaxRequest(
    "/admin/delete-flight-route",
    "POST",
    formData,
    successCallback,
    failureCallback,
    false);
}
FlightRoute.prototype.deleteFlightRouteFetchDataSuccess =function (response){
    $(".delete-button").attr("disabled", false).val("Update");
    if (response.success == true) {
        flight_route.getflightRoute();
        swal({
            title: "Success!",
            text: "Flight Route deleted!",
            imageHeight: 30,
            animation: false,
        });
    } else {
        swal({
            title: "Info!",
            text: response.message,
            type: "info",
            imageHeight: 30,
            animation: false,
        });
    }
};




var flight_route    =   new FlightRoute();
jQuery(function (){
    flight_route.getflightRoute();
    $(document)
    .find(".pagination")
    .on("click", "a", function (event) {
      event.preventDefault();
      flight_route.page = $(this).attr("href").split("page=")[1];
      flight_route.getflightRoute();
    });
})
$(document).on("click", ".delete-button ", function (event) {
   
    event.preventDefault();
    var id = $(this).data("id");
    swal({
        title: "Are you sure?",
        text: "The selected Flight Route will be deleted!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, keep it",
    }).then((result) => {
        if (id) {
            flight_route.deleteFlightRoute(id);
        } else {
            swal("Cancelled", "Your data is safe :)", "error");
        }
    });
});