function Flight() {
    this.listingContainer = $("#flight_content");
    this.limit = 20;
    this.page = 1;
    this.pagination = $(".pagination");
  }
  Flight.prototype.getFlight = function () {
    var formData = new FormData();
    formData.append("limit", flight.limit);
    formData.append("page", flight.page);
    var successCallback = flight.flightFetchDataSuccess;
    var failureCallback = flight.fetchDataFailure;
    app.ajaxRequest(
      "/admin/list-flight",
      "POST",
      formData,
      successCallback,
      failureCallback,
      false
    );
  };
  Flight.prototype.fetchDataFailure = function (response) {
    console.log(response);
  };
  Flight.prototype.flightFetchDataSuccess = function (response) {
    flight.listingContainer.html("");
    flight.pagination.html("");
    if (response.data.results.data == undefined || response.data.results.data.length == 0) {
        flight.listingContainer.append(
        '<tr><td colspan="9" class="text-center">Flight not found.</td></tr>'
      );
    } else {
      var i = (response.data.results.current_page - 1) * 20 + 1;
      $.each(response.data.results.data, function (key, flight_data) {
        console.log(flight_data)
        flight.listingContainer.append(
          '<tr id="' +
          flight_data.id +
            '">' +
            "<td>" +
            (i + key) +
            "</td>" +
            "<td>" +
            flight_data.flight_category.title+
            "</td>" +
            "<td>" +
            flight_data.flight_route.title +
            "</td>" +
            "<td>" +
            flight_data.seat_available +
            "</td>" +
            "<td>" +
            flight_data.date +
            "</td>" +
            "<td>" +
            flight_data.arrival_time +
            "</td>" +
            "<td>" +
            flight_data.departure_time +
            "</td>" +
            "<td>" +
            flight_data.fare +
            "</td>" +
            "<td>" +
            flight_data.remark +
            "</td>" +
           
            "<td>" +
            '<div class="btn-group btn-group-sm ">' +
            '<a href ="/admin/flight/' +
            btoa(flight_data.id) +
            '/edit" data-toggle="tooltip" title="Edit Flight" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>' +
            '<a href ="/admin/flight/' +
            btoa(flight_data.id) +
            '/view" data-toggle="tooltip" title="View Flight" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-eye"></span></button></a>' +
            '<button type="button" data-id="' +
           btoa( flight_data.id) +
            '" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>' +
            "</div>" +
            "</td>" +
            "</tr>"
        );
      });
      flight.pagination.html(response.data.link);
      // console.log( package.pagination);
    }
  };
  Flight.prototype.deleteFlight =function(id){
  var formData    = new FormData ();
  formData.append('id',id)
  var successCallback = flight.deleteFlightFetchDataSuccess;
    var failureCallback = flight.fetchDataFailure;
    app.ajaxRequest(
      "/admin/delete-flight",
      "POST",
      formData,
      successCallback,
      failureCallback,
      false
    );
  }
  Flight.prototype.deleteFlightFetchDataSuccess=function(response){
    $(".delete-button").attr("disabled", false).val("Update");
    if (response.success == true) {
       flight.getFlight();
        swal({
            title: "Success!",
            text: "Flight deleted!",
            imageHeight: 30,
            animation: false,
        });
    } else {
        swal({
            title: "Info!",
            text: response.message,
            type: "info",
            imageHeight: 30,
            animation: false,
        });
    }
  }
  var flight = new Flight();
  jQuery(function () {
    flight.getFlight();
    $(document)
      .find(".pagination")
      .on("click", "a", function (event) {
        event.preventDefault();
        flight.page = $(this).attr("href").split("page=")[1];
        flight.getFlight();
      });
  
  
  });
  $(document).on("click", ".delete-button ", function (event) {
     
    event.preventDefault();
    var id = $(this).data("id");
    swal({
        title: "Are you sure?",
        text: "The selected Flight will be deleted!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, keep it",
    }).then((result) => {
        if (id) {
            flight.deleteFlight(id);
        } else {
            swal("Cancelled", "Your data is safe :)", "error");
        }
    });
  });
  