function FlightCategory(){
    this.data = {};
    this.listingContainer = $("#category_content");
    this.pagination = $(".pagination");
    this.limit = 20;
    this.page = 1;
}
FlightCategory.prototype.fetchDataFailure =function(response){
    console.log(response);
}
FlightCategory.prototype.getCategory   =   function(){
  
  
   var formData =new FormData()
   formData.append('limit',flight_category.limit)
   formData.append('page',flight_category.page)
   var successCallback = flight_category.flightFetchDataSuccess;
   var failureCallback = flight_category.fetchDataFailure;
   app.ajaxRequest(
    "/admin/list-flight-category",
    "POST",
    formData,
    successCallback,
    failureCallback,
    false);

}
FlightCategory.prototype.flightFetchDataSuccess =function(response){
    flight_category.listingContainer.html("");
    flight_category.pagination.html("")
    if (
        response.data.data == undefined ||
        response.data.data.length == 0
    ) {
        flight_category.listingContainer.append(
            '<tr><td colspan="9" class="text-center">category not found.</td></tr>'
        );
    }
    else{
        $.each(response.data.data,function(key,category_data){
            flight_category.listingContainer.append(
                '<tr id="'+category_data.id+'">'+
                '<td>'+
                category_data.title+
                '</td>'+
                '<td>'+
                     '<div class="btn-group btn-group-sm ">'+
                     '<a href ="/admin/flight-category/'+btoa(category_data.id)+'/edit" data-toggle="tooltip" title="Edit Category" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>'+
                     '<button type="button" data-id="'+category_data.id+'" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>'+
                    '</div>'+
                '</td>'+
            '</tr>')
        })
    }
}
FlightCategory.prototype.deleteCategory    =   function (id){
    var formData    = new FormData()
    formData.append('id',id)
    var successCallback = flight_category.deletecetgoryFetchDataSuccess;
   var failureCallback = flight_category.fetchDataFailure;
   app.ajaxRequest(
    "/admin/delete-flight-category",
    "POST",
    formData,
    successCallback,
    failureCallback,
    false);
}
FlightCategory.prototype.deletecetgoryFetchDataSuccess =function (response){
    $(".delete-button").attr("disabled", false).val("Update");
    if (response.success == true) {
        flight_category.getCategory();
        swal({
            title: "Success!",
            text: "Category deleted!",
            imageHeight: 30,
            animation: false,
        });
    } else {
        swal({
            title: "Info!",
            text: response.message,
            type: "info",
            imageHeight: 30,
            animation: false,
        });
    }
};




var flight_category    =   new FlightCategory();
jQuery(function (){
    flight_category.getCategory();
})
$(document).on("click", ".delete-button ", function (event) {
   
    event.preventDefault();
    var id = $(this).data("id");
    swal({
        title: "Are you sure?",
        text: "The selected Category will be deleted!",
        icon: "warning",
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, keep it",
    }).then((result) => {
        if (id) {
            flight_category.deleteCategory(id);
        } else {
            swal("Cancelled", "Your data is safe :)", "error");
        }
    });
});