function Image(){
	this.data               = {};
	this.element            = '';
  this.listingContainer   = $('#image_content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
  this.preloaded          = {};
  this.formData           = {};
}

Image.prototype.init = function() 
{
  // $('.input-images').imageUploader({
  //     // preloaded: image.preloaded,
  //     imagesInputName: 'image',
  //     preloadedInputName: 'old',
  //     maxSize: 1 * 1024 * 1024,
  //     maxFiles: 1

  // });
  // var image = $(document).find('input[name^="image"]');
  // image.attr('data-validation','required');
  // image.attr('data-validation-error-msg','The image is required.');
  app.validate();


  
};

Image.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Image.prototype.getImage = function()
{

    var formData = new FormData(); 
    var params = window.location.href.split('/')
    formData.append('folder_id',params['5'])
    formData.append('limit', image.limit );
    formData.append('page', image.page );
    var successCallback = image.imageFetchDataSuccess;
    var failureCallback = image.fetchDataFailure;
    app.ajaxRequest('/admin/get-image-list','POST',formData,successCallback,failureCallback,false);
}

Image.prototype.imageFetchDataSuccess = function(response) 
{
    
    image.listingContainer.html("");
    image.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
     {
          image.listingContainer.append('<div class="tile image upload-image">'+
                          '<i class="mdi mdi-plus"></i>'+
                          '<h3>Add New</h3>'+
                        '</div> ' );    
    }
    else
    {
      $.each(response.data.results.data,function(key,image_data)
      {
          image.listingContainer.append(
                '<div class="grid-item col-sm-6 col-md-6 col-lg-4 col-xl-3 latest">'+
                   // '<i class="mdi mdi-close"></i>'+
                  '<div class="gallery-box">'+
                      '<div class="gallery-preview">'+
                          '<img src="'+image_data.full_path+image_data.filename+'_200x200.'+image_data.extension+'" class="img-fluid" alt="gallery image"/>'+
                      '</div>'+
                      '<div class="gallery-content">'+
                          '<p>'+moment(image_data.created_at).format('DD-MM-YYYY')+'</p>'+
                          '<h5><a href="#">'+image_data.name+'</a></h5>'+
                      '</div>'+     
                  '</div>'+
              '</div>'
                  )
        });
       
        image.pagination.html(response.data.link);
    }
   

};

Image.prototype.getSingleImage = function(id)
{
    var formData = new FormData(); 
    formData.append('id', id );
    var successCallback = image.singleImageFetchDataSuccess;
    var failureCallback = image.fetchDataFailure;
    app.ajaxRequest('/admin/get-single-image','POST',formData,successCallback,failureCallback,false);
}


Image.prototype.singleImageFetchDataSuccess = function(response) 
{
    $("#id").val(response.data.image.id);
    $("#image").val(response.data.image.name);
    $("#create-modal-label").html("Update  Image");
    $(".create-submit-btn").html("Update");
    $("#create-modal").modal("show");
}

Image.prototype.createImage = function(id)
{
    $(".create-submit-btn").attr("disabled", true).val("Loading");
    var formData =  image.formData
    var successCallback = image.createImageFetchDataSuccess;
    var failureCallback = image.fetchDataFailure;
    app.ajaxRequest('/admin/create-image','POST',formData,successCallback,failureCallback,false);
}

Image.prototype.createImageFetchDataSuccess = function(response) 
{
      $(".create-submit-btn").attr("disabled", false).val("Create");
      $("#create-modal-label").html("Create  Image");
      $(".create-submit-btn").html("Create");
      if(response.success == true)
      {
         swal({
              title: 'Success!',
              text: ' Image created!',
              imageHeight: 30,
              animation: false,
              type: 'success',
         });
          
          $("#id").val("");
          $("#image").val("");
          $("#create-modal").modal("hide");

          image.getImage();

      }
      else
      {
        app.error(response.message)
      }
  
};

Image.prototype.updateImage = function(id)
{
    $(".create-submit-btn").attr("disabled", false).val("Loading");
    var formData =  image.formData

    var successCallback = image.updateImageFetchDataSuccess;
    var failureCallback = image.fetchDataFailure;
    app.ajaxRequest('/admin/update-image','POST',formData,successCallback,failureCallback,false);
}

Image.prototype.updateImageFetchDataSuccess = function(response) 
{
   swal({
         title: 'Success!',
          text: ' Image updated!',
          imageHeight: 30,
          animation: false
    });

   $(".create-submit-btn").attr("disabled", false).val("Create");
    $("#create-modal-label").html("Create  Image");
    $(".create-submit-btn").html("Create");
    $("#create-modal").modal("hide");
    image.getImage();

};

var image = new Image();



jQuery(function () 
{
  

    image.init();

    image.listingContainer.html(app.generateLoader(1 ));
    image.getImage();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      image.page = $(this).attr('href').split('page=')[1];
      image.getImage();
     
    })

     $(document).on('click','.upload-image',function(){
      $("#name").val("")
      $("#create-modal-label").html("Create  Image");
      $(".create-submit-btn").html("Create");
      $("#create-modal").modal("show");

    });

    $(document).on('click','.design-image',function(){
      window.location.href = '/admin/cropper';  
    });
     

      
    
    $('#create-modal').on('hidden.bs.modal', function () {
     

      $("#create-modal-label").html("Create  Image");
      $(".create-submit-btn").html("Create");
    });


    $("#create-form").submit(function(event){
        event.preventDefault();
        event.stopPropagation();
        var params = window.location.href.split('/')
        image.formData =  new FormData(this);
        image.formData.append('folder_uid',params['5'])
        var id =  $("#id").val();
        if(id.length == 0 || id == '')
        {
          image.createImage();
        }
        else
        {
          image.updateImage(id);
        }
    })

   
});