function ServiceLocation(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 3;
  this.listingContainer   = $('#service_location-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
}


ServiceLocation.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




ServiceLocation.prototype.getServiceLocation = function()
{

    var formData = new FormData(); 
    formData.append('limit', service_location.limit );
    formData.append('page', service_location.page );
    // formData.append("filter[search]", $('#search').val() );
    var successCallback = service_location.service_locationFetchDataSuccess;
    var failureCallback = service_location.fetchDataFailure;
    app.ajaxRequest('/admin/get-location-list','POST',formData,successCallback,failureCallback,false);
}

ServiceLocation.prototype.service_locationFetchDataSuccess = function(response) 
{
    
    service_location.listingContainer.html("");
    service_location.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       service_location.listingContainer.append('<tr><td colspan="4" class="text-center">ServiceLocation not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,service_location_data)
      {
          service_location.listingContainer.append(
              '<tr id="'+service_location_data.id+'">'+
              
              '<td>'+
              service_location_data.name+
              '</td>'+
               '<td>'+
              service_location_data.pincode+
              '</td>'+
              '<td>'+
              service_location_data.latitude+
              '</td>'+
              '<td>'+
              service_location_data.longitude+
              '</td>'+
                '<td>'+
              ( (service_location_data.is_active == 1) ? 'Active' : 'Inactive' )+
              '</td>'+
             '<td>'+
                   '<div class="btn-group btn-group-sm ">'+
                     '<button type="button" data-id="'+service_location_data.id+'" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button>'+
                  '</div>'+
              '</td>'+
             
          '</tr>')
        });
        
        service_location.pagination.html(response.data.link);
    }
   

};

ServiceLocation.prototype.getSingleServiceLocation = function(id)
{
    var formData = new FormData(); 
    formData.append('id', id );
    var successCallback = service_location.singleServiceLocationFetchDataSuccess;
    var failureCallback = service_location.fetchDataFailure;
    app.ajaxRequest('/admin/get-single-location','POST',formData,successCallback,failureCallback,false);
}


ServiceLocation.prototype.singleServiceLocationFetchDataSuccess = function(response) 
{
    $("#id").val(response.data.service_location.id);
    $("#name").val(response.data.service_location.name);
    $("#pincode").val(response.data.service_location.pincode);
    $("#latitude").val(response.data.service_location.latitude);
    $("#longitude").val(response.data.service_location.longitude);
    if(response.data.service_location.is_active == 1)
    {
       $("#is_active").attr('checked',true)
    }
    else
    {
      $("#is_active").attr('checked',false)
    }

    $("#create-modal-label").html("Update  ServiceLocation");
    $(".create-submit-btn").html("Update");
    $("#create-modal").modal("show");
}

ServiceLocation.prototype.createServiceLocation = function(id)
{
    $(".create-submit-btn").attr("disabled", true).val("Loading");
    var formData = new FormData(); 
    formData.append('name', $("#name").val() );
    formData.append('pincode', $("#pincode").val() );
    formData.append('latitude', $("#latitude").val() );
    formData.append('longitude', $("#longitude").val() );
    formData.append('is_active', ($('#is_active').is(":checked") ? 1: 0)  );
    var successCallback = service_location.createServiceLocationFetchDataSuccess;
    var failureCallback = service_location.fetchDataFailure;
    app.ajaxRequest('/admin/create-location','POST',formData,successCallback,failureCallback,false);
}

ServiceLocation.prototype.createServiceLocationFetchDataSuccess = function(response) 
{
   swal({
          title: 'Success!',
          text: ' ServiceLocation created!',
          imageHeight: 30,
          animation: false
   });
    
    $(".create-submit-btn").attr("disabled", false).val("Create");
    $("#id").val("");
    $("#name").val("");
    $("#pincode").val("");
    $("#latitude").val("");
    $("#longitude").val("");
    $("#create-modal-label").html("Create  ServiceLocation");
    $(".create-submit-btn").html("Create");
    $("#create-modal").modal("hide");
    service_location.getServiceLocation();

};

ServiceLocation.prototype.updateServiceLocation = function(id)
{
    $(".create-submit-btn").attr("disabled", false).val("Loading");
    var formData = new FormData(); 
    formData.append('id', $("#id").val() );
    formData.append('name', $("#name").val() );
    formData.append('pincode', $("#pincode").val() );
    formData.append('latitude', $("#latitude").val() );
    formData.append('longitude', $("#longitude").val() );
    formData.append('is_active', ($('#is_active').is(":checked") ? 1: 0)  );
    var successCallback = service_location.updateServiceLocationFetchDataSuccess;
    var failureCallback = service_location.fetchDataFailure;
    app.ajaxRequest('/admin/update-location','POST',formData,successCallback,failureCallback,false);
}

ServiceLocation.prototype.updateServiceLocationFetchDataSuccess = function(response) 
{
   swal({
         title: 'Success!',
          text: ' Service Location updated!',
          imageHeight: 30,
          animation: false
    });

   $(".create-submit-btn").attr("disabled", false).val("Create");
    $("#id").val("");
    $("#name").val("");
    $("#pincode").val("");
    $("#latitude").val("");
    $("#longitude").val("");
    $("#create-modal-label").html("Create  Service Location");
    $(".create-submit-btn").html("Create");
    $("#create-modal").modal("hide");
    service_location.getServiceLocation();

};

var service_location = new ServiceLocation();



jQuery(function () 
{
    
    app.validate();
    app.setZipCodeMask();
    service_location.listingContainer.html(app.generateLoader(service_location.colspan ));
    service_location.getServiceLocation();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      service_location.page = $(this).attr('href').split('page=')[1];
      service_location.getServiceLocation();
     
    })

    $(".right-action").click(function(){

      $("#id").val("");
      $("#name").val("");
      $("#pincode").val("");
      $("#latitude").val("");
      $("#longitude").val("");
      $("#create-modal-label").html("Create  Service Location");
      $(".create-submit-btn").html("Create");
      $("#create-modal").modal("show");

    });
    

    $(document).on("click", ".edit-button ",function(event){

      var id = $(this).data('id') 
      service_location.getSingleServiceLocation(id);
    });

    $('#create-modal').on('hidden.bs.modal', function () {
      $("#id").val("");
      $("#name").val("");
      $("#pincode").val("");
      $("#latitude").val("");
      $("#longitude").val("");
      $("#create-modal-label").html("Create  Service Location");
      $(".create-submit-btn").html("Create");
    });

    $("#create-form").submit(function(event){
      event.preventDefault();
      var id =  $("#id").val();
      if(id.length == 0 || id == '')
      {
        service_location.createServiceLocation();
      }
      else
      {
        service_location.updateServiceLocation(id);
      }
    })

   
});