function Order(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 11;
  this.listingContainer   = $('#order-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
}


Order.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Order.prototype.getOrder = function()
{

    var formData = new FormData(); 
    formData.append('limit', order.limit );
    formData.append('page', order.page );
    formData.append('search', $('#search').val());
    var successCallback = order.orderFetchDataSuccess;
    var failureCallback = order.fetchDataFailure;
    app.ajaxRequest('/admin/get-admin-orders-list','POST',formData,successCallback,failureCallback,false);
}

Order.prototype.orderFetchDataSuccess = function(response) 
{
    
    order.listingContainer.html("");
    order.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       order.listingContainer.append('<tr><td colspan="7" class="text-center">Order not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,order_data)
      {

        var date    = new Date(order_data.created_at),
            yr      = date.getFullYear(),
            month   = (date.getMonth()+1) < 10 ? '0' + (date.getMonth()+1) : (date.getMonth()+1),
            day     = date.getDate()  < 10 ? '0' + date.getDate()  : date.getDate(),
            newDate = day + '-' + month + '-' + yr;         
            
          order.listingContainer.append(
              '<tr>'+
               '<td>'+newDate+'</td>>'+
               '<td>'+order_data.invoice_number+'</td>>'+
               '<td>'+order_data.reseller.name+'</td>>'+
               '<td>₹'+order_data.total_cost.makeNumber()+'</td>'+
               '<td>'+order_data.address+'</td>'+
               '<td>'+order_data.payment_option.name+'</td>'+
               '<td>'+
                    '<div class="button-list">'+
                        '<a href="/admin/order-details/'+order_data.uid+'" class="btn btn-primary-rgba"><i class="feather icon-arrow-up-right"></i></a>'+
                    '</div>'+
                '</td>'+
               
          '</tr>')
        });
        
        order.pagination.html(response.data.link);
    }

    
   

};

var order = new Order();



jQuery(function () 
{
    
    order.listingContainer.html(app.generateLoader(order.colspan ));
    order.getOrder();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      order.page = $(this).attr('href').split('page=')[1];
      order.getOrder();
     
    })

    $("#search").change(function(event)
    {
      event.preventDefault();
     order.getOrder();
    });

   
});