function Image(){
	this.data               = {};
	this.element            = '';
  this.listingContainer   = $('#image_content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
  this.preloaded          = {};
  this.formData           = {};
  this.package_id            = $('#package_id').val();
}

Image.prototype.init = function() 
{

  app.validate();


  
};

Image.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Image.prototype.getImage = function()
{

    var formData = new FormData(); 
    formData.append('limit', gallery.limit );
    formData.append('page', gallery.page );
    formData.append('package_id', gallery.package_id );
    var successCallback = gallery.imageFetchDataSuccess;
    var failureCallback = gallery.fetchDataFailure;
    app.ajaxRequest('admin/package-gallery','POST',formData,successCallback,failureCallback,false);
}

Image.prototype.imageFetchDataSuccess = function(response) 
{
    
    gallery.listingContainer.html("");
    gallery.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
     {
          gallery.listingContainer.append('<div class="tile image upload-image">'+
                          '<h3>Gallery empty!</h3>'+
                        '</div> ' );    
    }
    else
    {
      $.each(response.data.results.data,function(key,image_data)
      {
          gallery.listingContainer.append(
                '<div class="grid-item col-sm-6 col-md-6 col-lg-4 col-xl-3 latest">'+
                   '<i class="mdi mdi-trash-can text-danger pointer-icon delete-image" data-id="'+image_data.id+'"></i>'+
                  '<div class="gallery-box">'+
                      '<div class="gallery-preview">'+
                          '<img src="'+image_data.image+'" class="img-fluid" alt="gallery image"/>'+
                      '</div>'+    
                  '</div>'+
              '</div>'
                  )
        });
       
        gallery.pagination.html(response.data.link);
    }
   

};

Image.prototype.deleteGalleryImage = function(id)
{
    var formData = new FormData(); 
    formData.append('id', id );
    var successCallback = gallery.deleteGalleryImageFetchDataSuccess;
    var failureCallback = gallery.fetchDataFailure;
    app.ajaxRequest('admin/delete/package-gallery-image','POST',formData,successCallback,failureCallback,false);
}

Image.prototype.deleteGalleryImageFetchDataSuccess = function(response) 
{
      
     swal({
          title: 'Success!',
          text: ' Image deleted!',
          imageHeight: 30,
          animation: false,
          type: 'success',
     });
     gallery.getImage();
}

var gallery = new Image();



jQuery(function () 
{
  

    gallery.init();

    gallery.listingContainer.html(app.generateLoader(1 ));
    gallery.getImage();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      gallery.page = $(this).attr('href').split('page=')[1];
      gallery.getImage();
     
    });
     
    $(document).on('click',".delete-image",function(event)
    {
      event.preventDefault();
      var id = $(this).data("id");

       swal({
            title: 'Are you sure?',
            text: "You want to delete this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonClass: 'btn btn-success',
            cancelButtonClass: 'btn btn-danger m-l-10',
            confirmButtonText: 'Yes'
        }).then(function () {
           gallery.deleteGalleryImage(id)
            
        })
     

    }); 
});