function Package() {
  this.listingContainer = $("#package_content");
  this.limit = 20;
  this.page = 1;
  this.pagination = $(".pagination");
}
Package.prototype.getPackage = function () {
  var formData = new FormData();
  formData.append("limit", package.limit);
  formData.append("page", package.page);
  var successCallback = package.packageFetchDataSuccess;
  var failureCallback = package.fetchDataFailure;
  app.ajaxRequest(
    "/admin/list-package",
    "POST",
    formData,
    successCallback,
    failureCallback,
    false
  );
};
Package.prototype.fetchDataFailure = function (response) {
  console.log(response);
};
Package.prototype.packageFetchDataSuccess = function (response) {
  package.listingContainer.html("");
  package.pagination.html("");
  if (response.data.result.data == undefined || response.data.result.data.length == 0) {
    package.listingContainer.append(
      '<tr><td colspan="9" class="text-center">category not found.</td></tr>'
    );
  } else {
    var i = (response.data.result.current_page - 1) * 20 + 1;
    $.each(response.data.result.data, function (key, pacakage_data) {
      package.listingContainer.append(
        '<tr id="' +
          pacakage_data.id +
          '">' +
          "<td>" +
          (i + key) +
          "</td>" +
          "<td>" +
          pacakage_data.title +
          "</td>" +
          "<td>" +
          pacakage_data.description +
          "</td>" +
          "<td>" +
          pacakage_data.title +
          "</td>" +
          "<td>" +
          pacakage_data.title +
          "</td>" +
          "<td>" +
          '<img src="' +
          pacakage_data.image +
          '" width="40" height="40"> ' +
          "</td>" +
          "<td>" +
          '<div class="btn-group btn-group-sm ">' +
          '<a href ="/admin/package/' +
          btoa(pacakage_data.id) +
          '/edit" data-toggle="tooltip" title="Edit Package" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>' +
          '<a href ="/admin/package/' +
          btoa(pacakage_data.id) +
          '/view" data-toggle="tooltip" title="View Package" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-eye"></span></button></a>' +
          '<a href ="/admin/package/' +
          btoa(pacakage_data.id) +
          '/gallery" data-toggle="tooltip" title="Gallry Image" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-image"></span></button></a>' +
          '<button type="button" data-id="' +
          btoa(pacakage_data.id) +
          '" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>' +
          "</div>" +
          "</td>" +
          "</tr>"
      );
    });
    package.pagination.html(response.data.link);
   
    
  }
};
Package.prototype.deletePackage = function (id) {
  var formData = new FormData();
  formData.append("id", id);
  var successCallback = package.deletePackageFetchDataSuccess;
  var failureCallback = package.fetchDataFailure;
  app.ajaxRequest(
    "/admin/delete-package",
    "POST",
    formData,
    successCallback,
    failureCallback,
    false
  );
};
Package.prototype.deletePackageFetchDataSuccess = function (response) {
  $(".delete-button").attr("disabled", false).val("Update");
  if (response.success == true) {
    package.getPackage();
    swal({
      title: "Success!",
      text: "Package deleted!",
      imageHeight: 30,
      animation: false,
    });
  } else {
    swal({
      title: "Info!",
      text: response.message,
      type: "info",
      imageHeight: 30,
      animation: false,
    });
  }
};
var package = new Package();
jQuery(function () {
  package.getPackage();
  $(document)
    .find(".pagination")
    .on("click", "a", function (event) {
      event.preventDefault();
      package.page = $(this).attr("href").split("page=")[1];
      package.getPackage();
    });
});
$(document).on("click", ".delete-button ", function (event) {
  event.preventDefault();
  var id = $(this).data("id");
  swal({
    title: "Are you sure?",
    text: "The selected Package will be deleted!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Yes, delete it!",
    cancelButtonText: "No, keep it",
  }).then((result) => {
    if (id) {
      package.deletePackage(id);
    } else {
      swal("Cancelled", "Your data is safe :)", "error");
    }
  });
});
