function PackageCategory(){
    this.data = {};
    this.listingContainer = $("#category_content");
    this.pagination = $(".pagination");
    this.limit = 20;
    this.page = 1;
}
PackageCategory.prototype.fetchDataFailure =function(response){
    console.log(response);
}
PackageCategory.prototype.getCategory   =   function(){
   var formData =new FormData()
   formData.append('limit',package_category.limit)
   formData.append('page',package_category.page)
   var successCallback = package_category.cetgoryFetchDataSuccess;
   var failureCallback = package_category.fetchDataFailure;
   app.ajaxRequest(
    "/admin/list-package-category",
    "POST",
    formData,
    successCallback,
    failureCallback,
    false);

}
PackageCategory.prototype.cetgoryFetchDataSuccess =function(response){
    package_category.listingContainer.html("");
    package_category.pagination.html("")
    if (
        response.data.data == undefined ||
        response.data.data.length == 0
    ) {
        package_category.listingContainer.append(
            '<tr><td colspan="9" class="text-center">category not found.</td></tr>'
        );
    }
    else{
        $.each(response.data.data,function(key,category_data){
            package_category.listingContainer.append(
                '<tr id="'+category_data.id+'">'+
                '<td>'+
                category_data.title+
                '</td>'+
                '<td>'+
                     '<div class="btn-group btn-group-sm ">'+
                     '<a href ="/admin/package-category/'+btoa(category_data.id)+'/edit" data-toggle="tooltip" title="Edit Category" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>'+
                     '<button type="button" data-id="'+category_data.id+'" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>'+
                    '</div>'+
                '</td>'+
            '</tr>')
        })
    }
}
PackageCategory.prototype.deleteCategory    =   function (id){
    var formData    = new FormData()
    formData.append('id',id)
    var successCallback = package_category.deletecetgoryFetchDataSuccess;
   var failureCallback = package_category.fetchDataFailure;
   app.ajaxRequest(
    "/admin/delete-pacakage-category",
    "POST",
    formData,
    successCallback,
    failureCallback,
    false);
}
PackageCategory.prototype.deletecetgoryFetchDataSuccess =function (response){
    $(".delete-button").attr("disabled", false).val("Update");
    if (response.success == true) {
        package_category.getCategory();
        swal({
            title: "Success!",
            text: "Category deleted!",
            imageHeight: 30,
            animation: false,
        });
    } else {
        swal({
            title: "Info!",
            text: response.message,
            type: "info",
            imageHeight: 30,
            animation: false,
        });
    }
};




var package_category    =   new PackageCategory();
jQuery(function (){
    package_category.getCategory();
})
$(document).on("click", ".delete-button ", function (event) {
   
    event.preventDefault();
    var id = $(this).data("id");
    swal({
        title: "Are you sure?",
        text: "The selected Category will be deleted!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, keep it",
    }).then((result) => {
        if (id) {
            package_category.deleteCategory(id);
        } else {
            swal("Cancelled", "Your data is safe :)", "error");
        }
    });
});