function Pincode(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 6;
  this.listingContainer   = $('#pincode-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
}


Pincode.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Pincode.prototype.getPincode = function()
{
    var formData = new FormData(); 
    formData.append('limit', pincode.limit );
    formData.append('page', pincode.page );
    formData.append("search", $('#search').val() );
    var successCallback = pincode.pincodeFetchDataSuccess;
    var failureCallback = pincode.fetchDataFailure;
    app.ajaxRequest('/admin/get-pincode-list','POST',formData,successCallback,failureCallback,false);
}

Pincode.prototype.pincodeFetchDataSuccess = function(response) 
{
    
    pincode.listingContainer.html("");
    pincode.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       pincode.listingContainer.append('<tr><td colspan="4" class="text-center">Pincode not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,pincode_data)
      {
          pincode.listingContainer.append(
              '<tr id="'+pincode_data.id+'">'+
              
              '<td >'+
              pincode_data.pincode+
              '</td>'+
               '<td class="text-center">'+
              pincode_data.address+
              '</td>'+
              '<td class="text-center">'+
              pincode_data.city['name']+
              '</td>'+
              '<td class="text-center">'+
              pincode_data.state['name']+
              '</td>'+
              '<td class="text-center" >'+
                   '<div class="btn-group btn-group-sm ">'+
                     '<button type="button" data-id="'+pincode_data.id+'" class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button>'+

                  '</div>'+
              '</td>'+
             
          '</tr>')
        });
        
        pincode.pagination.html(response.data.link);
    }
   

};

Pincode.prototype.getSinglePincode = function(id)
{
    var formData = new FormData(); 
    formData.append('id', id );
    var successCallback = pincode.singlePincodeFetchDataSuccess;
    var failureCallback = pincode.fetchDataFailure;
    app.ajaxRequest('/admin/get-single-pincode','POST',formData,successCallback,failureCallback,false);
}


Pincode.prototype.singlePincodeFetchDataSuccess = function(response) 
{
    $("#id").val(response.data.pincode.id);
    $("#pincode").val(response.data.pincode.pincode);
    $("#address").val(response.data.pincode.address);
    $("#city_id").val(response.data.pincode.city_id);
    $("#state_id").val(response.data.pincode.state_id);

    $("#create-modal-label").html("Update Pincode");
    $(".create-submit-btn").html("Update");
    $("#create-modal").modal("show");
}

Pincode.prototype.createPincode = function(id)
{
    $(".create-submit-btn").attr("disabled", true).val("Loading");
    var formData = new FormData(); 
    formData.append('pincode', $("#pincode").val() );
    formData.append('address', $("#address").val() );
    formData.append('city', $("#city_id").val() );
    formData.append('state_id', $("#state_id").val() );
    var successCallback = pincode.createPincodeFetchDataSuccess;
    var failureCallback = pincode.fetchDataFailure;
    app.ajaxRequest('/admin/create-pincode','POST',formData,successCallback,failureCallback,false);
}

Pincode.prototype.createPincodeFetchDataSuccess = function(response) 
{
    $(".create-submit-btn").attr("disabled", false).val("Create");
    if(response.success == true)
    {
      swal({
            title: 'Success!',
            text: ' Pincode created!',
            imageHeight: 30,
            animation: false
      });
      
      
      $("#id").val("");
      $("#pincode").val("");
      $("#address").val("");
      $("#city_id").val("");
      $("#state_id").val("");
      $("#create-modal-label").html("Create Pincode");
      $(".create-submit-btn").html("Create");
      $("#create-modal").modal("hide");
      Pincode.getPincode();
  }
  else
  {
      swal({
            title: 'Info!',
            text: response.message,
            type:'info',
            imageHeight: 30,
            animation: false
      });
  }
   

};

Pincode.prototype.updatePincode = function(id)
{
    $(".create-submit-btn").attr("disabled", false).val("Loading");
    var formData = new FormData(); 
    formData.append('id', $("#id").val() );
    formData.append('pincode', $("#pincode").val() );
    formData.append('address', $("#address").val() );
    formData.append('city_id', $("#city_id").val() );
    formData.append('state_id', $("#state_id").val() );
   
    var successCallback = pincode.updatePincodeFetchDataSuccess;
    var failureCallback = pincode.fetchDataFailure;
    app.ajaxRequest('/admin/update-pincode','POST',formData,successCallback,failureCallback,false);
}

Pincode.prototype.updatePincodeFetchDataSuccess = function(response) 
{

   $(".create-submit-btn").attr("disabled", false).val("Update");
    if(response.success == true)
    {
        swal({
           title: 'Success!',
            text: 'Pincode updated!',
            imageHeight: 30,
            animation: false
        });

        $(".create-submit-btn").attr("disabled", false).val("Create");
        $("#id").val("");
        $("#pincode").val("");
        $("#address").val("");
        $("#city_id").val("");
        $("#state_id").val("");
        $("#create-modal-label").html("Create Pincode");
        $(".create-submit-btn").html("Create");
        $("#create-modal").modal("hide");
        pincode.getPincode();
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};

var pincode = new Pincode();



jQuery(function () 
{
    
    app.validate();
    app.setZipCodeMask();
    app.setPhoneMask();
    pincode.listingContainer.html(app.generateLoader(pincode.colspan ));
    pincode.getPincode();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      pincode.page = $(this).attr('href').split('page=')[1];
      pincode.getPincode();
     
    })

    $(".right-action").click(function(){

      $("#id").val("");
      $("#pincode").val("");
      $("#address").val("");
      $("#city_id").val("");
      $("#state_id").val("");
      $("#create-modal-label").html("Create Pincode");
      $(".create-submit-btn").html("Create");
      $("#create-modal").modal("show");

    });
    

    $(document).on("click", ".edit-button ",function(event){

      var id = $(this).data('id') 
      pincode.getSinglePincode(id);
    });

    

    $('#create-modal').on('hidden.bs.modal', function () {
      $("#id").val("");
      $("#pincode").val("");
      $("#address").val("");
      $("#city_id").val("");
      $("#state_id").val("");
      $("#create-modal-label").html("Create Pincode");
      $(".create-submit-btn").html("Create");
    });

    $("#create-form").submit(function(event){
      event.preventDefault();
      var id =  $("#id").val();
      if(id.length == 0 || id == '')
      {
        pincode.createPincode();
      }
      else
      {
        pincode.updatePincode(id);
      }
    });

    $("#search").change(function(event)
    {
      event.preventDefault();
      pincode.getPincode();
    });

   
});
