function Product(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 5;
  this.listingContainer   = $('#product-type-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;

}

Product.prototype.init = function() 
{
  
};

Product.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Product.prototype.getProduct = function()
{

    var formData = new FormData(); 
    formData.append('limit', product.limit );
    formData.append('page', product.page );
    // formData.append("filter[search]", $('#search').val() );
    var successCallback = product.productFetchDataSuccess;
    var failureCallback = product.fetchDataFailure;
    app.ajaxRequest('/admin/get-product-type-list','POST',formData,successCallback,failureCallback,false);
}

Product.prototype.productFetchDataSuccess = function(response) 
{
    product.listingContainer.html("");
    product.pagination.html("");
     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       product.listingContainer.append('<tr><td colspan="5" class="text-center">Product not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,product_data)
      {
          product.listingContainer.append(
              '<tr id="'+product_data.id+'">'+
              '<td>'+product_data.name+'</td>'+
              '<td>'+product_data.slug+'</td>'+
             '<td>'+
                   '<div class="btn-group btn-group-sm ">'+
                   '<a href ="/admin/product-type/'+btoa(product_data.id)+'/edit"><button type="button" data-id="" class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>'+
                   '<button type="button" data-id="'+product_data.id+'" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>'+
                  '</div>'+
              '</td>'+
             
          '</tr>')
        });
        
        product.pagination.html(response.data.link);
    }
   

};

Product.prototype.getSingleProduct = function(id)
{
    var formData = new FormData(); 
    formData.append('id', id );
    var successCallback = product.singleProductFetchDataSuccess;
    var failureCallback = product.fetchDataFailure;
    app.ajaxRequest('/admin/get-single-product-type','POST',formData,successCallback,failureCallback,false);
}


Product.prototype.singleProductFetchDataSuccess = function(response) 
{
    
    $("#id").val(response.data.product.id);
    $("#name").val(response.data.product.name);
    $("#create-modal-label").html("Update  Product");
    $(".create-submit-btn").html("Update");
    $("#create-modal").modal("show");
}

Product.prototype.delProduct = function(id)
{
    var formData = new FormData(); 
    formData.append('id', id );
    var successCallback = product.deleteProductFetchDataSuccess;
    var failureCallback = product.fetchDataFailure;
    app.ajaxRequest('/admin/delete-product-type','POST',formData,successCallback,failureCallback,false);
}

Product.prototype.deleteProductFetchDataSuccess = function(response) 
{

   $(".delete-button").attr("disabled", false).val("Delete");
    if(response.success == true)
    {
        product.getProduct();
        swal({
           title: 'Success!',
            text: 'Product Type Deleted!',
            imageHeight: 30,
            animation: false
        });
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};



var product = new Product();



jQuery(function () 
{
    
    app.validate();
    product.listingContainer.html(app.generateLoader(product.colspan ));
    product.getProduct();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      product.page = $(this).attr('href').split('page=')[1];
      product.getProduct();
     
    })


   
});

$(document).on("click", ".delete-button ",function(event){

    event.preventDefault();
    var id = $(this).data('id') 
    swal({
      title: 'Are you sure?',
      text: 'The selected Product Type will be deleted!',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, delete it!',
      cancelButtonText: 'No, keep it'
    }).then((result) => {
      if (id) {
        product.delProduct(id);
      } else {
        swal(
          'Cancelled',
          'Your data is safe :)',
          'error'
        )
      }
    })  
});
