function Product() {
  this.data = {};
  this.element = '';
  this.colspan = 10;
  this.listingContainer = $('#product-content');
  this.pagination = $('.pagination');
  this.limit = 10;
  this.page = 1;
}


Product.prototype.fetchDataFailure = function (response) {
  console.log(response);
};




Product.prototype.getProduct = function () {

  var formData = new FormData();
  formData.append('limit', product.limit);
  formData.append('page', product.page);
  formData.append("search", $('#search').val());
  var successCallback = product.productFetchDataSuccess;
  var failureCallback = product.fetchDataFailure;
  app.ajaxRequest('/admin/get-all-items', 'POST', formData, successCallback, failureCallback, false);
}

Product.prototype.productFetchDataSuccess = function (response) {

  product.listingContainer.html("");
  product.pagination.html("");

  if (response.data.results == undefined || response.data.results.data.length == 0) {
    product.listingContainer.append('<tr><td colspan="6" class="text-center">Product not found.</td></tr>');
  }
  else {
    $.each(response.data.results.data, function (key, product_data) {
      var image = '<img src="' + product_data.image + '" class="img-fluid" width="35" alt="product">';
      product.listingContainer.append(
        '<tr scope="row">' +
        '<td>' + image + '</td>>' +
        '<td >' + product_data.sku + '</td>' +
        '<td class="limited-text" title="' + product_data.name + '">' + product_data.name + '</td>' +
        '<td>₹' + product_data.price.makeNumber() + '</td>' +
        '<td>' + product_data.vendor.name + '</td>' +
        '<td>' +
        ((product_data.stock == 1) ? '<span class="badge badge-success">Available</span>' : '<span class="badge badge-danger">Out of Stock</span>') +
        '</td>' +
        '<td>' +
        '<div class="button-list">' +
        '<a href="/admin/edit-product/' + product_data.uid + '" class="btn btn-warning-rgba"><i class="feather icon-edit-2"></i></a>' +
        '<a href="/admin/' + btoa(product_data.id) + '/gallery-list" class="btn btn-info-rgba"><i class="feather icon-image"></i></a>' +
        '<a href="/admin/products/' + btoa(product_data.id) + '/item-variants" class="btn btn-primary-rgba"><i class="feather icon-layers"></i></a>' +
        // '<a href="/admin/products/' + btoa(product_data.id) + '/delivery-charge" class="btn btn-primary-rgba"><i class="feather icon-truck"></i></a>' +
        '<a href="/admin/products/' + btoa(product_data.id) + '/review" class="btn btn-success-rgba"><i class="feather icon-star"></i></a>' +
        '<button type="button" data-id="' + product_data.id + '" class="delete-button btn btn-danger-rgba"><i class="feather icon-trash-2"></button>' +

        '</div>' +
        '</td>' +

        '</tr>')
    });

    product.pagination.html(response.data.link);
  }




};

Product.prototype.deleteProduct = function (id) {
  var formData = new FormData();
  formData.append('id', id);
  var successCallback = product.deleteProductFetchDataSuccess;
  var failureCallback = product.fetchDataFailure;
  app.ajaxRequest('/admin/delete-item', 'POST', formData, successCallback, failureCallback, false);
}

Product.prototype.deleteProductFetchDataSuccess = function (response) {

  $(".delete-button").attr("disabled", false).val("Delete");
  if (response.success == true) {
    product.getProduct();
    swal({
      title: 'Success!',
      text: 'Product Deleted!',
      imageHeight: 30,
      animation: false
    });
  }
  else {
    swal({
      title: 'Info!',
      text: response.message,
      type: 'info',
      imageHeight: 30,
      animation: false
    });
  }


};



var product = new Product();



jQuery(function () {

  app.validate();
  app.setZipCodeMask();
  product.listingContainer.html(app.generateLoader(product.colspan));
  product.getProduct();

  $(document).find(".pagination").on("click", "a", function (event) {
    event.preventDefault();
    product.page = $(this).attr('href').split('page=')[1];
    product.getProduct();

  })

  $(".right-action").click(function () {

    window.location = '/admin/create-product'

  });


  $(document).on("click", ".edit-button ", function (event) {

    var id = $(this).data('id')
    product.getSingleProduct(id);
  });

  $('#create-modal').on('hidden.bs.modal', function () {
    $("#id").val("");
    $("#name").val("");
    $("#pincode").val("");
    $("#create-modal-label").html("Create  Service Location");
    $(".create-submit-btn").html("Create");
  });

  $("#create-form").submit(function (event) {
    event.preventDefault();
    var id = $("#id").val();
    if (id.length == 0 || id == '') {
      product.createProduct();
    }
    else {
      product.updateProduct(id);
    }
  });

  $("#search").change(function (event) {
    event.preventDefault();
    product.getProduct();
  });




});

$(document).on("click", ".delete-button ", function (event) {

  event.preventDefault();
  var id = $(this).data('id')
  swal({
    title: 'Are you sure?',
    text: 'The selected Product will be deleted!',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Yes, delete it!',
    cancelButtonText: 'No, keep it'
  }).then((result) => {
    if (id) {
      product.deleteProduct(id);
    } else {
      swal(
        'Cancelled',
        'Your data is safe :)',
        'error'
      )
    }
  })

});