function Notification(){
  this.data               = {};
  this.element            = '';
  this.colspan            = 10;
  this.listingContainer   = $('#push-notification-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
}


Notification.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Notification.prototype.getNotification = function()
{

    var formData = new FormData(); 
    formData.append('limit', notification.limit );
    formData.append('page', notification.page );
    formData.append("search", $('#search').val() );
    var successCallback = notification.notificationFetchDataSuccess;
    var failureCallback = notification.fetchDataFailure;
    app.ajaxRequest('/admin/push-notification-list','POST',formData,successCallback,failureCallback,false);
}

Notification.prototype.notificationFetchDataSuccess = function(response) 
{
    
    notification.listingContainer.html("");
    notification.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       notification.listingContainer.append('<tr><td colspan="'+notification.colspan+'" class="text-center">Notification not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,notification_data)
      {
        notification.listingContainer.append(
              '<tr id="'+notification_data.id+'">'+
              '<td>'+
              notification_data.title+
              '</td>'+
               '<td style="overflow:hidden;text-overflow:ellipsis">'+
               notification_data.description+
              '</td>'+
              '<td>'+
                   '<img src="'+notification_data.image+'" style="width:35px;" class="img-fluid" alt="logo image"/>'+
              '</td>'+

             '<td>'+
                   '<div class="btn-group btn-group-sm ">'+
                     '<a href ="/admin/push-notification/'+btoa(notification_data.id)+'/view"><button type="button" data-id="" class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="ti-new-window"></span></button></a>'+
                    //  '<button type="button" data-id="'+notification_data.id+'" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>'+


                  '</div>'+
              '</td>'+
             
          '</tr>')
        });
        
        notification.pagination.html(response.data.link);
    }
   

};
Notification.prototype.changeStatus = function(id)
{
    var formData        = new FormData(); 
    formData.append('id', id );
    var successCallback = notification.changeStatusFetchDataSuccess;
    var failureCallback = notification.fetchDataFailure;
    app.ajaxRequest('/admin/change-notification-status','POST',formData,successCallback,failureCallback,false);
}

Notification.prototype.changeStatusFetchDataSuccess = function(response) 
{

   $(".status-button").attr("disabled", false).val("Update");
    if(response.success == true)
    {
        notification.getNotification();
        swal({
           title: 'Success!',
            text: 'Notification Status Changed!',
            imageHeight: 30,
            animation: false
        });
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};

Notification.prototype.deleteNotification = function(id)
{
    var formData        = new FormData(); 
    formData.append('id', id );
    var successCallback = notification.deleteNotificationFetchDataSuccess;
    var failureCallback = notification.fetchDataFailure;
    app.ajaxRequest('/admin/delete-notification','POST',formData,successCallback,failureCallback,false);
}

Notification.prototype.deleteNotificationFetchDataSuccess = function(response) 
{

   $(".delete-button").attr("disabled", false).val("Delete");
    if(response.success == true)
    {
        notification.getNotification();
        swal({
           title: 'Success!',
            text: 'Notification Deleted!',
            imageHeight: 30,
            animation: false
        });
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};

var notification = new Notification();



jQuery(function () 
{
    
    app.validate();
    app.setZipCodeMask();
    notification.listingContainer.html(app.generateLoader(notification.colspan ));
    notification.getNotification();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      notification.page = $(this).attr('href').split('page=')[1];
      notification.getNotification();
     
    })

    $(".right-action").click(function(){

      window.location = '/admin/create-notification'

    });
    

    $(document).on("click", ".edit-button ",function(event){

      var id = $(this).data('id') 
      notification.getSingleNotification(id);
    });

    $('#create-modal').on('hidden.bs.modal', function () {
      $("#id").val("");
      $("#name").val("");
      $("#pincode").val("");
      $("#create-modal-label").html("Create  Service Location");
      $(".create-submit-btn").html("Create");
    });

    $("#create-form").submit(function(event){
      event.preventDefault();
      var id =  $("#id").val();
      if(id.length == 0 || id == '')
      {
        notification.createNotification();
      }
      else
      {
        notification.updateNotification(id);
      }
    });

     $("#search").change(function(event)
    {
      event.preventDefault();
     notification.getNotification();
    });

    $(document).on("click", ".delete-button ",function(event){

      event.preventDefault();
      var id = $(this).data('id') 
      swal({
        title: 'Are you sure?',
        text: 'The selected Notification will be deleted!',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'No, keep it'
      }).then((result) => {
        if (id) {
          notification.deleteNotification(id);
        } else {
          swal(
            'Cancelled',
            'Your data is safe :)',
            'error'
          )
        }
      })  
       
      });

    $(document).on("click", ".status-button ",function(event){

      var id = $(this).data('id') 
      notification.changeStatus(id);
    });

   
});