function UserAddress(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 3;
  this.listingContainer   = $('#address-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
  this.reseller_id        = $('#id').val();
}


UserAddress.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




UserAddress.prototype.getUserAddress = function()
{
    var formData = new FormData(); 
    formData.append('limit', address.limit );
    formData.append('page', address.page );
    formData.append('id', address.reseller_id );
    var successCallback = address.addressFetchDataSuccess;
    var failureCallback = address.fetchDataFailure;
    app.ajaxRequest('/admin/reseller/get-address-list','POST',formData,successCallback,failureCallback,false);
}

UserAddress.prototype.addressFetchDataSuccess = function(response) 
{
    
    address.listingContainer.html("");
    address.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       address.listingContainer.append('<tr><td colspan="7" class="text-center">No Address.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,address_data)
      {

          address.listingContainer.append(
              '<tr id="'+address_data.id+'">'+
              '<td>'+
              address_data.reseller.name+
              '</td>'+
              '<td>'+
              address_data.contact_name+
              '</td>'+
              '<td>'+
              address_data.house_name+
              '</td>'+
              '<td>'+
              address_data.landmark+
              '</td>'+
              '<td>'+
              address_data.city+
              '</td>'+
              '<td>'+
              address_data.mobile_number+
              '</td>'+
              '<td>'+
              address_data.pincode+
              '</td>'+
            
          '</tr>')
        });
        
        address.pagination.html(response.data.link);
    }
   

};



var address = new UserAddress();



jQuery(function () 
{
    
    app.validate();
    app.setZipCodeMask();
    address.listingContainer.html(app.generateLoader(address.colspan ));
    address.getUserAddress();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      address.page = $(this).attr('href').split('page=')[1];
      address.getUserAddress();
     
    }) 
});

function replaceAll(string, search, replace) 
{
  return string.split(search).join(replace);
}
