function Reseller(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 3;
  this.listingContainer   = $('#reseller-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
}


Reseller.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Reseller.prototype.getReseller = function()
{
    var formData = new FormData(); 
    formData.append('limit', reseller.limit );
    formData.append('page', reseller.page );
    formData.append("search", $('#search').val() );
    var successCallback = reseller.resellerFetchDataSuccess;
    var failureCallback = reseller.fetchDataFailure;
    app.ajaxRequest('/admin/get-reseller-list','POST',formData,successCallback,failureCallback,false);
}

Reseller.prototype.resellerFetchDataSuccess = function(response) 
{
    
    reseller.listingContainer.html("");
    reseller.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       reseller.listingContainer.append('<tr><td colspan="6" class="text-center">Reseller not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,reseller_data)
      {
        var status = (reseller_data.is_active  == 1) ? '<button type="button" data-id="'+reseller_data.id+'" class="status-button btn btn-sm btn-danger" style="float: none; margin:5px;">Deactivate</button>' : '<button type="button" data-id="'+reseller_data.id+'" class="status-button btn btn-sm btn-success" style="float: none; margin:5px;">Activate</button>';  
        reseller.listingContainer.append(             
              '<tr id="'+reseller_data.id+'">'+
              '<td >'+
              reseller_data.name+
              '</td>'+
              '<td>'+
               reseller_data.address+
              '</td>'+
              '<td >'+
              reseller_data.phone+
              '</td>'+
              '<td >'+
              reseller_data.email+
              '</td>'+
              '<td>'+
              ((reseller_data.is_active  == 1) ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-danger">Inactive</span>' )+
              '</td>'+
             '<td>'+
                   '<div class="btn-group btn-group-sm ">'+
                  //  '<a href="/admin/reseller/'+btoa(reseller_data.id)+'/edit"><button type="button"  class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>'+
                   '<a href="/admin/reseller/'+btoa(reseller_data.id)+'/address-list"><button type="button"  class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="fa fa-address-book-o"></span></button></a>'+
                   status+
                   '</div>'+
              '</td>'+
             
          '</tr>')
        });
        
        reseller.pagination.html(response.data.link);
    }
};

Reseller.prototype.delReseller = function(id)
{
    var formData = new FormData(); 
    formData.append('id', id );
    var successCallback = reseller.deleteResellerFetchDataSuccess;
    var failureCallback = reseller.fetchDataFailure;
    app.ajaxRequest('/admin/delete-reseller','POST',formData,successCallback,failureCallback,false);
}

Reseller.prototype.deleteResellerFetchDataSuccess = function(response) 
{

   $(".delete-button").attr("disabled", false).val("Delete");
    if(response.success == true)
    {
        reseller.getReseller();
        swal({
           title: 'Success!',
            text: 'Reseller Deleted!',
            imageHeight: 30,
            animation: false
        });
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};

Reseller.prototype.changeStatus = function(id)
{
    var formData        = new FormData(); 
    formData.append('id', id );
    var successCallback = reseller.changeStatusFetchDataSuccess;
    var failureCallback = reseller.fetchDataFailure;
    app.ajaxRequest('/admin/change-reseller-status','POST',formData,successCallback,failureCallback,false);
}

Reseller.prototype.changeStatusFetchDataSuccess = function(response) 
{

   $(".status-button").attr("disabled", false).val("Update");
    if(response.success == true)
    {
      reseller.getReseller();
        swal({
           title: 'Success!',
            text: 'Reseller Status Changed!',
            imageHeight: 30,
            animation: false
        });
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};





var reseller = new Reseller();



jQuery(function () 
{
    
    app.validate();
    app.setZipCodeMask();
    reseller.listingContainer.html(app.generateLoader(reseller.colspan ));
    reseller.getReseller();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      reseller.page = $(this).attr('href').split('page=')[1];
      reseller.getReseller();
     
    }) 
});

function replaceAll(string, search, replace) 
{
  return string.split(search).join(replace);
}

$("#search").change(function(event)
{
  event.preventDefault();
  Reseller.getReseller();
});

$(document).on("click", ".delete-button ",function(event){

    event.preventDefault();
    var id = $(this).data('id') 
    swal({
      title: 'Are you sure?',
      text: 'The selected Reseller will be deleted!',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, delete it!',
      cancelButtonText: 'No, keep it'
    }).then((result) => {
      if (id) {
        reseller.delReseller(id);
      } else {
        swal(
          'Cancelled',
          'Your data is safe :)',
          'error'
        )
      }
    })  
});

$(document).on("click", ".status-button ",function(event){

  var id = $(this).data('id') 
  reseller.changeStatus(id);
});