function Review(){
  this.data               = {};
  this.element            = '';
  this.colspan            = 10;
  this.listingContainer   = $('#review-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
  this.item_id            = $('#id').val();
}


Review.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Review.prototype.getReview = function()
{
    var formData = new FormData(); 
    formData.append('limit', review.limit );
    formData.append('id', review.item_id );
    formData.append('page', review.page );
    formData.append("search", $('#search').val() );
    var successCallback = review.reviewFetchDataSuccess;
    var failureCallback = review.fetchDataFailure;
    app.ajaxRequest('/admin/get-reviews','POST',formData,successCallback,failureCallback,false);
}

Review.prototype.reviewFetchDataSuccess = function(response) 
{
    
    review.listingContainer.html("");
    review.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       review.listingContainer.append('<tr><td colspan="4" class="text-center">Review not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,review_data)
      {
         
          review.listingContainer.append(
              '<tr scope="row">'+
               '<td>'+review_data.reseller.name+'</td>>'+
               '<td>'+review_data.rating+'</td>>'+
               '<td style="overflow:hidden;text-overflow:ellipsis">'+review_data.review+'</td>>'+
              '<td>'+
                   '<div class="btn-group btn-group-sm ">'+
                   '<a href ="/admin/review/'+btoa(review_data.id)+'/edit"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>'+
                     '<button type="button" data-id="'+review_data.id+'" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>'+
                   '</div>'+
                '</td>'+
          '</tr>')
        });
        
        review.pagination.html(response.data.link);
    }

    
   

};

Review.prototype.deleteReview = function(id)
{
    var formData = new FormData(); 
    formData.append('id', id );
    var successCallback = review.deleteReviewFetchDataSuccess;
    var failureCallback = review.fetchDataFailure;
    app.ajaxRequest('/admin/delete-reviews','POST',formData,successCallback,failureCallback,false);
}


Review.prototype.deleteReviewFetchDataSuccess = function(response) 
{
  $(".delete-button").attr("disabled", false).val("Delete");
  if(response.success == true)
  {
      review.getReview();
      swal({
         title: 'Success!',
          text: 'Product Review Deleted!',
          imageHeight: 30,
          animation: false
      });
  }
  else
  {
      swal({
            title: 'Info!',
            text: response.message,
            type:'info',
            imageHeight: 30,
            animation: false
      });
  }


};


var review = new Review();



jQuery(function () 
{
    
    app.validate();
    app.setZipCodeMask();
    review.listingContainer.html(app.generateLoader(review.colspan ));
    review.getReview();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      review.page = $(this).attr('href').split('page=')[1];
      review.getReview();
     
    })

     $("#search").change(function(event)
    {
      event.preventDefault();
     review.getReview();
    });

    $(document).on("click", ".delete-button ",function(event){

      event.preventDefault();
      var id = $(this).data('id') 
      swal({
        title: 'Are you sure?',
        text: 'The selected Review will be deleted!',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'No, keep it'
      }).then((result) => {
        if (id) {
          review.deleteReview(id);
        } else {
          swal(
            'Cancelled',
            'Your data is safe :)',
            'error'
          )
        }
      })  
      
    });  
});