function Routes(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 3;
  this.listingContainer   = $('#route-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
}


Routes.prototype.fetchDataFailure = function(response) {
	console.log(response);
};



Routes.prototype.getDeliveryBoys = function()
{
   
    var successCallback = route.deliveryBoysFetchDataSuccess;
    var failureCallback = route.fetchDataFailure;
    app.ajaxRequest('/admin/get-all-routes','POST',{},successCallback,failureCallback,false);
}

Routes.prototype.deliveryBoysFetchDataSuccess = function(response) 
{

    $("#delivery_boy").html('<option value="">Select</option>');
    $.each(response.data.delivery_boys,function(key,delivery_boy)
    {
      $("#delivery_boy").append('<option value="'+delivery_boy.id+'">'+delivery_boy.name+'</option>');
    });
};

Routes.prototype.getDeliveryLocations = function()
{
   
    var successCallback = route.deliveryLocationsFetchDataSuccess;
    var failureCallback = route.fetchDataFailure;
    app.ajaxRequest('/admin/get-all-single-location','POST',{},successCallback,failureCallback,false);
}

Routes.prototype.deliveryLocationsFetchDataSuccess = function(response) 
{

    $("#delivery_locations").html('');
    $.each(response.data.locations,function(key,location)
    {
      $("#delivery_locations").append('<option value="'+location.id+'">'+location.pincode+'</option>');
    });
    app.select2();
};


Routes.prototype.getRoutes = function()
{
    var formData = new FormData(); 
    formData.append('limit', route.limit );
    formData.append('page', route.page );
    formData.append("search", $('#search').val() );
    var successCallback = route.routeFetchDataSuccess;
    var failureCallback = route.fetchDataFailure;
    app.ajaxRequest('/admin/get-route-list','POST',formData,successCallback,failureCallback,false);
}

Routes.prototype.routeFetchDataSuccess = function(response) 
{
    
    route.listingContainer.html("");
    route.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       route.listingContainer.append('<tr><td colspan="4" class="text-center">Routes not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,route_data)
      {
        var locations = "";
        $.each(route_data.locations , function(key2,location)
        {
          locations += location.location.name + ', ';
        });


          route.listingContainer.append(
              '<tr id="'+route_data.id+'">'+
              
              '<td >'+
              route_data.name+
              '</td>'+
               '<td>'+
                locations+
              '</td>'+
              '<td>'+
              route_data.delivery_boy.name+
              '</td>'+
             '<td>'+
                   '<div class="btn-group btn-group-sm ">'+
                     '<button type="button" data-id="'+route_data.id+'" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button>'+
                  '</div>'+
              '</td>'+
          '</tr>');

        });
        
        route.pagination.html(response.data.link);
    }
   

};

Routes.prototype.getSingleRoutes = function(id)
{
    var formData = new FormData(); 
    formData.append('id', id );
    var successCallback = route.singleRoutesFetchDataSuccess;
    var failureCallback = route.fetchDataFailure;
    app.ajaxRequest('/admin/get-single-route','POST',formData,successCallback,failureCallback,false);
}


Routes.prototype.singleRoutesFetchDataSuccess = function(response) 
{
    $("#id").val(response.data.route.id);
    $("#name").val(response.data.route.name);
    if( $("#delivery_boy option[value="+response.data.route.delivery_boy_id+"]").length == 0 )
    {
      $("#delivery_boy").append('<option selected value="'+response.data.route.delivery_boy_id+'">'+response.data.route.delivery_boy.name+'</option>');
    }
    var selectedValues = [];
    $.each(response.data.route.locations , function(key2,location)
    {
        selectedValues.push(location.location.id);
    });
    $("#delivery_locations").val(selectedValues);
    app.select2();

    $("#create-modal-label").html("Update  Route");
    $(".create-submit-btn").html("Update");
    $("#create-modal").modal("show");
}

Routes.prototype.createRoutes = function(id)
{
    $(".create-submit-btn").attr("disabled", true).val("Loading");
    var formData = new FormData(); 
    formData.append('name', $("#name").val() );
    formData.append('delivery_boy_id', $("#delivery_boy").val() );
    formData.append('delivery_locations', $("#delivery_locations").val() );

    var successCallback = route.createRoutesFetchDataSuccess;
    var failureCallback = route.fetchDataFailure;
    app.ajaxRequest('/admin/create-route','POST',formData,successCallback,failureCallback,false);
}

Routes.prototype.createRoutesFetchDataSuccess = function(response) 
{
    if(response.success == true)
    {
      swal({
            title: 'Success!',
            text: ' Route created!',
            imageHeight: 30,
            animation: false
      });
      
      $(".create-submit-btn").attr("disabled", false).val("Create");
      $("#id").val("");
      $("#name").val("");
      $("#delivery_boy").val("");

     $("#delivery_locations").val("").trigger('change');
      app.select2();
      $("#create-modal-label").html("Create  Routes");
      $(".create-submit-btn").html("Create");
      $("#create-modal").modal("hide");
      route.getRoutes();
  }
  else
  {
      swal({
            title: 'Info!',
            text: response.message,
            type:'info',
            imageHeight: 30,
            animation: false
      });
  }
   

};

Routes.prototype.updateRoutes = function(id)
{
    $(".create-submit-btn").attr("disabled", false).val("Loading");
    var formData = new FormData(); 
    formData.append('id', $("#id").val() );
    formData.append('name', $("#name").val() );
    formData.append('delivery_boy_id', $("#delivery_boy").val() );
    formData.append('delivery_locations', $("#delivery_locations").val() );
   
    var successCallback = route.updateRoutesFetchDataSuccess;
    var failureCallback = route.fetchDataFailure;
    app.ajaxRequest('/admin/update-route','POST',formData,successCallback,failureCallback,false);
}

Routes.prototype.updateRoutesFetchDataSuccess = function(response) 
{
   swal({
         title: 'Success!',
          text: 'Delivery  updated!',
          imageHeight: 30,
          animation: false
    });

   $(".create-submit-btn").attr("disabled", false).val("Create");
      $("#id").val("");
      $("#name").val("");
      $("#delivery_boy").val("");
      $("#delivery_locations").val("").trigger('change');
      app.select2();

    $("#create-modal-label").html("Create  Route");
    $(".create-submit-btn").html("Create");
    $("#create-modal").modal("hide");
    route.getRoutes();

};

var route = new Routes();



jQuery(function () 
{
    
    app.validate();
    app.setZipCodeMask();
    route.listingContainer.html(app.generateLoader(route.colspan ));
    route.getDeliveryBoys();
    route.getDeliveryLocations();
    route.getRoutes();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      route.page = $(this).attr('href').split('page=')[1];
      route.getRoutes();
     
    })

    $(".right-action").click(function(){

      $("#id").val("");
      $("#name").val("");
      $("#delivery_locations").val("").trigger('change');
      app.select2();
      $("#create-modal-label").html("Create  Route");
      $(".create-submit-btn").html("Create");
      $("#create-modal").modal("show");

    });
    

    $(document).on("click", ".edit-button ",function(event){

      var id = $(this).data('id') 
      route.getSingleRoutes(id);
    });

    $('#create-modal').on('hidden.bs.modal', function () 
    {
      $("#name").val("");
      $("#delivery_boy").val("");
      $("#delivery_locations").val("").trigger('change');
      app.select2();

      $("#create-modal-label").html("Create  Route");
      $(".create-submit-btn").html("Create");
    });

    $("#create-form").submit(function(event){
      event.preventDefault();
      var id =  $("#id").val();
      if(id.length == 0 || id == '')
      {
        route.createRoutes();
      }
      else
      {
        route.updateRoutes(id);
      }
    });

    $("#search").change(function(event)
    {
      event.preventDefault();
      route.getRoutes();
    });

   
});