function Size(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 3;
  this.listingContainer   = $('#size-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
}

Size.prototype.init = function() 
{
  
};

Size.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Size.prototype.getSize = function()
{

    var formData = new FormData(); 
    formData.append('limit', size.limit );
    formData.append('page', size.page );
    // formData.append("filter[search]", $('#search').val() );
    var successCallback = size.sizeFetchDataSuccess;
    var failureCallback = size.fetchDataFailure;
    app.ajaxRequest('/admin/get-size-list','POST',formData,successCallback,failureCallback,false);
}

Size.prototype.sizeFetchDataSuccess = function(response) 
{
    
    size.listingContainer.html("");
    size.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       size.listingContainer.append('<tr><td colspan="3" class="text-center">Size not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,size_data)
      {
          size.listingContainer.append(
              '<tr id="'+size_data.id+'">'+
              
              '<td>'+
              size_data.size+
              '</td>'+
                '<td>'+
              ( (size_data.is_active == 1) ? 'Active' : 'Inactive' )+
              '</td>'+
             '<td>'+
                   '<div class="btn-group btn-group-sm ">'+
                     '<button type="button" data-id="'+size_data.id+'" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button>'+
                  '</div>'+
              '</td>'+
             
          '</tr>')
        });
        
        size.pagination.html(response.data.link);
    }
   

};

Size.prototype.getSingleSize = function(id)
{
    var formData = new FormData(); 
    formData.append('id', id );
    var successCallback = size.singleSizeFetchDataSuccess;
    var failureCallback = size.fetchDataFailure;
    app.ajaxRequest('/admin/get-single-size','POST',formData,successCallback,failureCallback,false);
}


Size.prototype.singleSizeFetchDataSuccess = function(response) 
{
    $("#id").val(response.data.size.id);
    $("#size").val(response.data.size.size);
    if(response.data.size.is_active == 1)
    {
       $("#is_active").attr('checked',true)
    }
    else
    {
      $("#is_active").attr('checked',false)
    }

    $("#create-modal-label").html("Update  Size");
    $(".create-submit-btn").html("Update");
    $("#create-modal").modal("show");
}

Size.prototype.createSize = function(id)
{
    $(".create-submit-btn").attr("disabled", true).val("Loading");
    var formData = new FormData(); 
    formData.append('size', $("#size").val() );
    formData.append('is_active', ($('#is_active').is(":checked") ? 1: 0)  );
    var successCallback = size.createSizeFetchDataSuccess;
    var failureCallback = size.fetchDataFailure;
    app.ajaxRequest('/admin/create-size','POST',formData,successCallback,failureCallback,false);
}

Size.prototype.createSizeFetchDataSuccess = function(response) 
{
   swal({
          title: 'Success!',
          text: ' Size created!',
          imageHeight: 30,
          animation: false
   });
    
    $(".create-submit-btn").attr("disabled", false).val("Create");
    $("#id").val("");
    $("#size").val("");
    $("#create-modal-label").html("Create  Size");
    $(".create-submit-btn").html("Create");
    $("#create-modal").modal("hide");
    size.getSize();

};

Size.prototype.updateSize = function(id)
{
    $(".create-submit-btn").attr("disabled", false).val("Loading");
    var formData = new FormData(); 
    formData.append('id', $("#id").val() );
    formData.append('size', $("#size").val() );
    formData.append('is_active', ($('#is_active').is(":checked") ? 1: 0)  );
    var successCallback = size.updateSizeFetchDataSuccess;
    var failureCallback = size.fetchDataFailure;
    app.ajaxRequest('/admin/update-size','POST',formData,successCallback,failureCallback,false);
}

Size.prototype.updateSizeFetchDataSuccess = function(response) 
{
   swal({
         title: 'Success!',
          text: ' Size updated!',
          imageHeight: 30,
          animation: false
    });

   $(".create-submit-btn").attr("disabled", false).val("Create");
    $("#id").val("");
    $("#size").val("");
    $("#create-modal-label").html("Create  Size");
    $(".create-submit-btn").html("Create");
    $("#create-modal").modal("hide");
    size.getSize();

};

var size = new Size();



jQuery(function () 
{
    
    app.validate();
    size.listingContainer.html(app.generateLoader(size.colspan ));
    size.getSize();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      size.page = $(this).attr('href').split('page=')[1];
      size.getSize();
     
    })

    $(".right-action").click(function(){

      $("#id").val("");
      $("#size").val("");
      $("#create-modal-label").html("Create  Size");
      $(".create-submit-btn").html("Create");
      $("#create-modal").modal("show");

    });
    

    $(document).on("click", ".edit-button ",function(event){

      var id = $(this).data('id') 
      size.getSingleSize(id);
    });

    $('#create-modal').on('hidden.bs.modal', function () {
      $("#id").val("");
      $("#size").val("");

      $("#create-modal-label").html("Create  Size");
      $(".create-submit-btn").html("Create");
    });

    $("#create-form").submit(function(event){
      event.preventDefault();
      var id =  $("#id").val();
      if(id.length == 0 || id == '')
      {
        size.createSize();
      }
      else
      {
        size.updateSize(id);
      }
    })

   
});