function Slider(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 5;
  this.listingContainer   = $('#slider-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;

}

Slider.prototype.init = function() 
{
  
};

Slider.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Slider.prototype.getSlider = function()
{

    var formData = new FormData(); 
    formData.append('limit', slider.limit );
    formData.append('page', slider.page );
    // formData.append("filter[search]", $('#search').val() );
    var successCallback = slider.sliderFetchDataSuccess;
    var failureCallback = slider.fetchDataFailure;
    app.ajaxRequest('/admin/get-slider-list','POST',formData,successCallback,failureCallback,false);
}

Slider.prototype.sliderFetchDataSuccess = function(response) 
{
    slider.listingContainer.html("");
    slider.pagination.html("");
     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       slider.listingContainer.append('<tr><td colspan="4" class="text-center">Slider not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,slider_data)
      {
          slider.listingContainer.append(
              '<tr id="'+slider_data.id+'">'+
              '<td>'+
                slider_data.title+
              '</td>'+
              '<td>'+
                slider_data.description+
              '</td>'+
              '<td>'+
                '<img src="'+slider_data.image+'" style="width:35px;" class="img-fluid" alt="slider image"/>'+
              '</td>'+
             '<td>'+
                   '<div class="btn-group btn-group-sm ">'+
                   '<a href ="/admin/slider/'+btoa(slider_data.id)+'/edit"><button type="button" data-id="" class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>'+
                   '<button type="button" data-id="'+slider_data.id+'" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>'+
                  '</div>'+
              '</td>'+
             
          '</tr>')
        });
        
        slider.pagination.html(response.data.link);
    }
   

};

Slider.prototype.deleteSlider = function(id)
{
    var formData        = new FormData(); 
    formData.append('id', id );
    var successCallback = slider.deleteSliderFetchDataSuccess;
    var failureCallback = slider.fetchDataFailure;
    app.ajaxRequest('/admin/delete-slider','POST',formData,successCallback,failureCallback,false);
}

Slider.prototype.deleteSliderFetchDataSuccess = function(response) 
{

   $(".delete-button").attr("disabled", false).val("Delete");
    if(response.success == true)
    {
        slider.getSlider();
        swal({
           title: 'Success!',
            text: 'Slider Deleted!',
            imageHeight: 30,
            animation: false
        });
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};


var slider = new Slider();



jQuery(function () 
{
    
    app.validate();
    slider.listingContainer.html(app.generateLoader(slider.colspan ));
    slider.getSlider();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      slider.page = $(this).attr('href').split('page=')[1];
      slider.getSlider();
     
    })

    $(document).on("click", ".delete-button ",function(event){

      event.preventDefault();
        var id = $(this).data('id') 
        swal({
          title: 'Are you sure?',
          text: 'The selected Slider will be deleted!',
          icon: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Yes, delete it!',
          cancelButtonText: 'No, keep it'
        }).then((result) => {
          if (id) {
            slider.deleteSlider(id);
          } else {
            swal(
              'Cancelled',
              'Your data is safe :)',
              'error'
            )
          }
        })   
      
    });
   
});