function Vendor(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 3;
  this.listingContainer   = $('#unapproved-vendor-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
}


Vendor.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Vendor.prototype.getVendor = function()
{
    var formData = new FormData(); 
    formData.append('limit', vendor.limit );
    formData.append('page', vendor.page );
    formData.append("search", $('#search').val() );
    var successCallback = vendor.vendorFetchDataSuccess;
    var failureCallback = vendor.fetchDataFailure;
    app.ajaxRequest('/admin/get-unapproved-vendor-list','POST',formData,successCallback,failureCallback,false);
}

Vendor.prototype.vendorFetchDataSuccess = function(response) 
{
    
    vendor.listingContainer.html("");
    vendor.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       vendor.listingContainer.append('<tr><td colspan="5" class="text-center">Vendor not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,vendor_data)
      {
        var status = (vendor_data.is_approve  == null) ? '<button type="button" data-id="'+vendor_data.id+'" class="status-button btn btn-sm" style="float: none; margin:5px;background-color:#4F7942;color:#fff">Approve</button>' : '' ;  
        vendor.listingContainer.append(             
              '<tr id="'+vendor_data.id+'">'+
              '<td >'+
              vendor_data.name+
              '</td>'+
              '<td>'+
               vendor_data.address+
              '</td>'+
              '<td >'+
              vendor_data.phone+
              '</td>'+
              '<td >'+
              vendor_data.email+
              '</td>'+
              '<td>'+
                    '<div class="btn-group btn-group-sm ">'+
                    '<a href="/admin/vendor/'+btoa(vendor_data.id)+'/edit"><button type="button"  class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>'+
                    status+
                    '</div>'+
                '</td>'+
             
          '</tr>')
        });
        
        vendor.pagination.html(response.data.link);
    }
};


Vendor.prototype.changeStatus = function(id)
{
    var formData        = new FormData(); 
    formData.append('id', id );
    var successCallback = vendor.changeStatusFetchDataSuccess;
    var failureCallback = vendor.fetchDataFailure;
    app.ajaxRequest('/admin/change-vendor-approve-status','POST',formData,successCallback,failureCallback,false);
}

Vendor.prototype.changeStatusFetchDataSuccess = function(response) 
{

   $(".status-button").attr("disabled", false).val("Update");
    if(response.success == true)
    {
      vendor.getVendor();
        swal({
           title: 'Success!',
            text: 'Vendor Approved!',
            imageHeight: 30,
            animation: false
        });
    }
    else
    {
        swal({
              title: 'Info!',
              text: response.message,
              type:'info',
              imageHeight: 30,
              animation: false
        });
    }
 

};





var vendor = new Vendor();



jQuery(function () 
{
    
    app.validate();
    app.setZipCodeMask();
    vendor.listingContainer.html(app.generateLoader(vendor.colspan ));
    vendor.getVendor();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      vendor.page = $(this).attr('href').split('page=')[1];
      vendor.getVendor();
     
    }) 
});

function replaceAll(string, search, replace) 
{
  return string.split(search).join(replace);
}

$("#search").change(function(event)
{
  event.preventDefault();
  vendor.getVendor();
});



$(document).on("click", ".status-button ",function(event){

  var id = $(this).data('id') 
  vendor.changeStatus(id);
});