function Product(){
	this.data               = {};
	this.element            = '';
  this.colspan            = 3;
  this.listingContainer   = $('#unverified-product-content');
  this.pagination         = $('.pagination');
  this.limit              = 10;
  this.page               = 1;
}


Product.prototype.fetchDataFailure = function(response) {
	console.log(response);
};




Product.prototype.getProduct = function()
{
    var formData = new FormData(); 
    formData.append('limit', product.limit );
    formData.append('page', product.page );
    formData.append("search", $('#search').val() );
    var successCallback = product.productFetchDataSuccess;
    var failureCallback = product.fetchDataFailure;
    app.ajaxRequest('/admin/get-unverified-product-list','POST',formData,successCallback,failureCallback,false);
}

Product.prototype.productFetchDataSuccess = function(response) 
{
    
    product.listingContainer.html("");
    product.pagination.html("");

     if(response.data.results == undefined  || response.data.results.data.length == 0)
    {
       product.listingContainer.append('<tr><td colspan="7" class="text-center">Product not found.</td></tr>');
    }
    else
    {
      $.each(response.data.results.data,function(key,product_data)
      {
        var image = '<img src="'+product_data.image+'" class="img-fluid" width="35" alt="product">';  
        var status = (product_data.is_approve  == null) ? '<button type="button" data-id="'+product_data.id+'" class="status-button btn btn-sm" style="float: none; margin:5px;background-color:#4F7942;color:#fff">Approve</button>' : '' ;  
        product.listingContainer.append(             
              '<tr id="'+product_data.id+'">'+
              '<td>'+image+'</td>>'+
               '<td>'+product_data.name+'</td>'+
               '<td>₹'+product_data.price.makeNumber()+'</td>'+
              //  '<td>'+product_data.category.name+'</td>'+
               '<td>'+product_data.vendor.name+'</td>'+
              //  '<td>'+product_data.product_type.name+'</td>'+
              '<td>'+
                    '<div class="btn-group btn-group-sm ">'+
                    '<a href="/admin/view-product/'+btoa(product_data.id)+'"><button type="button"  class="edit-button btn btn-sm btn-primary" style="float: none; margin: 5px;"><span class="ti-eye"></span></button></a>'+
                    '</div>'+
                '</td>'+
          '</tr>')
        });
        
        product.pagination.html(response.data.link);
    }
};



var product = new Product();



jQuery(function () 
{
    
    app.validate();
    app.setZipCodeMask();
    product.listingContainer.html(app.generateLoader(product.colspan ));
    product.getProduct();

    $(document).find(".pagination").on("click", "a",function(event){
      event.preventDefault();
      product.page = $(this).attr('href').split('page=')[1];
      product.getProduct();
     
    }) 
});

function replaceAll(string, search, replace) 
{
  return string.split(search).join(replace);
}

$("#search").change(function(event)
{
  event.preventDefault();
  product.getProduct();
});