function Visa() {
    this.listingContainer = $("#visa_content");
    this.limit = 20;
    this.page = 1;
    this.pagination = $(".pagination");
  }
  Visa.prototype.getVisa = function () {
    var formData = new FormData();
    formData.append("limit", visa.limit);
    formData.append("page", visa.page);
    var successCallback = visa.visaFetchDataSuccess;
    var failureCallback = visa.fetchDataFailure;
    app.ajaxRequest(
      "/admin/list-visa",
      "POST",
      formData,
      successCallback,
      failureCallback,
      false
    );
  };
  Visa.prototype.fetchDataFailure = function (response) {
    console.log(response);
  };
  Visa.prototype.visaFetchDataSuccess = function (response) {
    visa.listingContainer.html("");
    visa.pagination.html("");
    if (response.data.results.data == undefined || response.data.results.data.length == 0) {
        visa.listingContainer.append(
        '<tr><td colspan="9" class="text-center">visa not found.</td></tr>'
      );
    } else {
      var i = (response.data.results.current_page - 1) * 20 + 1;
      $.each(response.data.results.data, function (key, visa_data) {
        var service =JSON.parse(visa_data.service_include)
        console.log(service)
        visa.listingContainer.append(
          '<tr id="' +
          visa_data.id +
            '">' +
            "<td>" +
            (i + key) +
            "</td>" +
            "<td>" +
            visa_data.title+
            "</td>" +
            "<td>" +
            visa_data.description+
            "</td>" +
         
            "<td>" +
            ((visa_data.visa_category)?visa_data.visa_category.title:"") +
            "</td>" +
            "<td>" +
            visa_data.fare +
            "</td>" +
            "<td>" +
            service +
            "</td>" +
           
           
           
            "<td>" +
            '<div class="btn-group btn-group-sm ">' +
            '<a href ="/admin/visa/' +
            btoa(visa_data.id) +
            '/edit" data-toggle="tooltip" title="Edit Category" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>' +
            '<button type="button" data-id="' +
           btoa( visa_data.id) +
            '" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>' +
            "</div>" +
            "</td>" +
            "</tr>"
        );
      });
      visa.pagination.html(response.data.link);
    }
  };
  Visa.prototype.deleteVisa =function(id){
  var formData    = new FormData ();
  formData.append('id',id)
  var successCallback = visa.deletevisaFetchDataSuccess;
    var failureCallback = visa.fetchDataFailure;
    app.ajaxRequest(
      "/admin/delete-visa",
      "POST",
      formData,
      successCallback,
      failureCallback,
      false
    );
  }
  Visa.prototype.deletevisaFetchDataSuccess=function(response){
    $(".delete-button").attr("disabled", false).val("Update");
    if (response.success == true) {
       visa.getVisa();
        swal({
            title: "Success!",
            text: "Visa deleted!",
            imageHeight: 30,
            animation: false,
        });
    } else {
        swal({
            title: "Info!",
            text: response.message,
            type: "info",
            imageHeight: 30,
            animation: false,
        });
    }
  }
  var visa = new Visa();
  jQuery(function () {
    visa.getVisa();
    $(document)
      .find(".pagination")
      .on("click", "a", function (event) {
        event.preventDefault();
        visa.page = $(this).attr("href").split("page=")[1];
      //   localStorage.setItem("lc_product_page", package.page);
        visa.getVisa();
      });
  
  
  });
  $(document).on("click", ".delete-button ", function (event) {
     
    event.preventDefault();
    var id = $(this).data("id");
    swal({
        title: "Are you sure?",
        text: "The selected Visa will be deleted!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, keep it",
    }).then((result) => {
        if (id) {
            visa.deleteVisa(id);
        } else {
            swal("Cancelled", "Your data is safe :)", "error");
        }
    });
  });
  