function VisaCategory(){
    this.data = {};
    this.listingContainer = $("#category_content");
    this.pagination = $(".pagination");
    this.limit = 20;
    this.page = 1;
}
VisaCategory.prototype.fetchDataFailure =function(response){
    console.log(response);
}
VisaCategory.prototype.getCategory   =   function(){
  
  
   var formData =new FormData()
   formData.append('limit',visa_category.limit)
   formData.append('page',visa_category.page)
   var successCallback = visa_category.visaFetchDataSuccess;
   var failureCallback = visa_category.fetchDataFailure;
   app.ajaxRequest(
    "/admin/list-visa-category",
    "POST",
    formData,
    successCallback,
    failureCallback,
    false);

}
VisaCategory.prototype.visaFetchDataSuccess =function(response){
    visa_category.listingContainer.html("");
    visa_category.pagination.html("")
    if (
        response.data.data == undefined ||
        response.data.data.length == 0
    ) {
        visa_category.listingContainer.append(
            '<tr><td colspan="9" class="text-center">category not found.</td></tr>'
        );
    }
    else{
        $.each(response.data.data,function(key,category_data){
            visa_category.listingContainer.append(
                '<tr id="'+category_data.id+'">'+
                '<td>'+
                category_data.title+
                '</td>'+
                '<td>'+
                     '<div class="btn-group btn-group-sm ">'+
                     '<a href ="/admin/visa-category/'+btoa(category_data.id)+'/edit" data-toggle="tooltip" title="Edit Category" class="tool_tip_cover"><button type="button" data-id="" class="edit-button btn btn-sm btn-info" style="float: none; margin: 5px;"><span class="ti-pencil"></span></button></a>'+
                     '<button type="button" data-id="'+category_data.id+'" class="delete-button btn btn-sm btn-danger" style="float: none; margin: 5px;"><span class="ti-trash"></span></button>'+
                    '</div>'+
                '</td>'+
            '</tr>')
        })
    }
}
VisaCategory.prototype.deleteCategory    =   function (id){
    var formData    = new FormData()
    formData.append('id',id)
    var successCallback = visa_category.deletecetgoryFetchDataSuccess;
   var failureCallback = visa_category.fetchDataFailure;
   app.ajaxRequest(
    "/admin/delete-visa-category",
    "POST",
    formData,
    successCallback,
    failureCallback,
    false);
}
VisaCategory.prototype.deletecetgoryFetchDataSuccess =function (response){
    $(".delete-button").attr("disabled", false).val("Update");
    if (response.success == true) {
        visa_category.getCategory();
        swal({
            title: "Success!",
            text: "Category deleted!",
            imageHeight: 30,
            animation: false,
        });
    } else {
        swal({
            title: "Info!",
            text: response.message,
            type: "info",
            imageHeight: 30,
            animation: false,
        });
    }
};




var visa_category    =   new VisaCategory();
jQuery(function (){
    visa_category.getCategory();
})
$(document).on("click", ".delete-button ", function (event) {
   
    event.preventDefault();
    var id = $(this).data("id");
    swal({
        title: "Are you sure?",
        text: "The selected Category will be deleted!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, keep it",
    }).then((result) => {
        if (id) {
            visa_category.deleteCategory(id);
        } else {
            swal("Cancelled", "Your data is safe :)", "error");
        }
    });
});