$(document).ready(function () {
  getCartCount();
});
var shipping_charge = 50;
var discount_amount = 0;

function getCartCount() {
  let cart = localStorage.getItem("cart");
  if (cart) {
    cart = JSON.parse(cart);
    let cartCount = cart.reduce((total, item) => total + item.quantity, 0);
    $(".cart-count").text(cartCount);
  } else {
    $(".cart-count").text(0);
  }
  getCartBill();
}

function getCartBill() {
  let cart = localStorage.getItem("cart");
  if (cart) {
    cart = JSON.parse(cart);
    let subtotal = cart.reduce(
      (total, item) => total + parseFloat(item.price) * item.quantity,
      0
    );
    $(".sub_total_cart").text(`${subtotal.toFixed(2)}`);
    $(".cart_shipping_charge").text(`${shipping_charge.toFixed(2)}`);
    $(".cart_discount_charge").text(`${discount_amount.toFixed(2)}`);
    var grand_total = subtotal + shipping_charge - discount_amount;
    $(".cart_grand_total").text(`${grand_total.toFixed(2)}`);
  } else {
    $(".sub_total_cart").text("0.00");
    $(".cart_shipping_charge").text("0.00");
    $(".cart_discount_charge").text("0.00");
    $(".cart_grand_total").text("0.00");
  }
}

function addToCart(variantId, variants) {
  let selectedVariant = variants.find((variant) => variant.id == variantId);
  if (!selectedVariant) {
    console.error(`Variant with ID ${variantId} not found.`);
  } else {
    let cart = JSON.parse(localStorage.getItem("cart")) || [];
    let existingItem = cart.find((item) => item.id == variantId);
    if (existingItem) {
      existingItem.quantity += 1;
    } else {
      cart.push({
        id: selectedVariant.id,
        name: selectedVariant.name,
        price: Number(parseFloat(selectedVariant.price).toFixed(2)),
        size: selectedVariant.size,
        color: selectedVariant.color,
        image: selectedVariant.image,
        quantity: 1, // Initial quantity
      });
    }
    localStorage.setItem("cart", JSON.stringify(cart));
    getCartCount();
    // alert('Added to cart!');
  }
}

function renderCartItems() {
  let cart = JSON.parse(localStorage.getItem("cart"));
  if (cart && cart.length > 0) {
    $("#cart-items").empty(); // Clear existing items
    cart.forEach(function (item) {
      $("#cart-items").append(`
                        <div class="align-items-center g-3">
                            <div class="">
                                <div class="row align-items-center">

                                    <div class="col-4 col-lg-2 cart-img text-center text-lg-start">
                                        <img src="${
                                          item.image
                                        }" width="130" alt="${item.name}">
                                    </div>

                                    <div class="col-8 col-lg-10 cart-detail">
                                    <div class="row align-items-center">

                                    <div class="col-md-12 col-lg-8">
                                    <h6 class="mb-2">${item.name}</h6>
                                    <div class="flex"> 
                                    ${
                                      item.size
                                        ? `<p>Size: <span>${item.size}</span></p>`
                                        : ""
                                    }
                                    ${
                                      item.color
                                        ? `<p>Color: <span>${item.color}</span></p>`
                                        : ""
                                    }
                                    </div>
                                    <h5 class="mb-0">₹${parseFloat(
                                      item.price
                                    ).toFixed(2)}</h5>
                                    </div>
                                
                            <div class="col-3 col-sm-3 col-md-2 col-lg-2">
                                <div class="cart-action text-center">
                                    <input type="number" class="form-control rounded-0 cart-quantity" data-id="${
                                      item.id
                                    }" value="${item.quantity}" min="1">
                                </div>
                            </div>
                            <div class="col-6 col-sm-2 col-md-2 col-lg-2">
                                <div class="text-center">
                                    <div class=" gap-3 justify-content-center justify-content-lg-end">
                                        <a href="javascript:;" class="d-flex align-items-center btn btn-outline-dark rounded-0 btn-remove" data-id="${
                                          item.id
                                        }"><i class="fa-solid fa-x"></i> Remove</a>
                                    </div>
                                </div>
                            </div>
                                    
                                    </div>
                                
                      
                                
                                    </div>
                                </div>

                            </div>
                        </div>
                        <hr>
                    `);
    });
  } else {
    $("#cart-items").html("<p>Your cart is empty.</p>");
  }
}

function updateCart(cart) {
  localStorage.setItem("cart", JSON.stringify(cart));
  renderCartItems();
  getCartCount();
}

$(document).on("change", ".cart-quantity", function () {
  let newQuantity = $(this).val();
  let itemId = $(this).data("id");
  let cart = JSON.parse(localStorage.getItem("cart"));

  cart.forEach(function (item) {
    if (item.id == itemId) {
      item.quantity = parseInt(newQuantity);
    }
  });
  updateCart(cart);
});

$(document).on("click", ".btn-remove", function () {
  let itemId = $(this).data("id");
  let cart = JSON.parse(localStorage.getItem("cart"));

  cart = cart.filter(function (item) {
    return item.id != itemId;
  });

  updateCart(cart);
});

function renderCheckoutItems() {
  let cart = JSON.parse(localStorage.getItem("cart"));
  if (cart && cart.length > 0) {
    $("#checkout_item_products").empty(); // Clear existing items
    cart.forEach(function (item) {
      $("#checkout_item_products").append(`
            <div class="d-flex align-items-center">
                <div class="Image">
                    <a class="d-block flex-shrink-0" href="javascript:;">
                        <img src="${item.image}" width="75" alt="${item.name}">
                    </a>
                </div>
                <div class="ps-2 Cnt">
                    <h6 class="mb-1">
                        <a href="javascript:;" class="text-dark">${
                          item.name
                        }</a>
                    </h6>
                </div>
                    <div class="widget-product-meta">
                         <span> ${item.quantity} x</span>
                        <span class="me-2">₹${parseFloat(item.price).toFixed(
                          2
                        )}</span>
                    </div>
            </div>
            <div class="my-3 border-top"></div>
        `);
    });
  } else {
    $("#checkout_item_products").html("<p>No items in your checkout.</p>");
  }
}
