@section('title')
Create Authors
@endsection
@extends('admin-layouts.main')
@section('style')

@endsection

@section('rightbar-action')

<!-- <button class="btn btn-primary-rgba right-action"><i class="feather icon-plus mr-2"></i>Actions</button> -->
@endsection


@section('rightbar-content')
<!-- Start Contentbar -->
<div class="contentbar">
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">
                    <div class="row align-items-center">
                    </div>
                </div>
                <form method="POST" action="{{route('admin.author.create.p')}}" enctype="multipart/form-data" id="create-form">
                    {{csrf_field()}}
                    <div class="card-body">
                        <input type="hidden" id="id" value="">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group has-feedback">
                                    <label for="color" class="col-form-label">Author Name</label>
                                    <input type="text" class="form-control {{ $errors->has('name') ? ' has-error' : '' }}"
                                        name="name"
                                        id="name"
                                        data-validation="required length"
                                        data-validation-length="3-200"
                                        data-validation-error-msg="Name is required &  limit to 3-200 characters."
                                        placeholder="Name"
                                        value="{{old('name')}}" />
                                </div>
                                @if ($errors->has('name'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('name') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group image">
                                    <label for="file" class="col-form-label">Image</label><br>
                                    <!-- <img src="" id="image-view" width="150" height="150" alt="No Image Selected"> -->
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="image"
                                            id="image"
                                            name="image"
                                            accept="image/*"
                                            onchange="readImage(this);">
                                        <label class="custom-file-label" for="customFile">Choose file</label>

                                    </div>

                                </div>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group has-feedback">
                                    <label for="color" class="col-form-label">Author Bio</label>
                                    <textarea name="bio" id="author-bio" class="form-control {{ $errors->has('bio') ? ' has-error' : '' }}"></textarea>
                                </div>
                                @if ($errors->has('author_bio'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('author_bio') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                    </div>


            </div>
            <div class="card m-b-30">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col-6">
                            <button type="submit" class="btn btn-primary create-submit-btn">Save</button>
                        </div>
                    </div>
                </div>
            </div>
            </form>


        </div>
    </div>
    <!-- End col -->
</div>
<!-- End row -->
</div>


<!-- End Contentbar -->
@endsection
@section('script')


@endsection